/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.LocalizedStringReplacement;
import com.openexchange.tools.TimeZoneUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Locale;

public final class SeriesReplacement
extends LocalizedStringReplacement {
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] WEEKDAYS = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Sunday", "Weekday", "Weekend day"};
    private static final String[] MONTHLY_DAY = new String[]{"first", "second", "third", "fourth", "last"};
    private CalendarObject calendarObject;
    private boolean isTask;

    public SeriesReplacement(CalendarObject calendarObject, boolean isTask) {
        super(TemplateToken.SERIES, null);
        this.calendarObject = calendarObject;
        this.isTask = isTask;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SeriesReplacement clone = (SeriesReplacement)super.clone();
        clone.calendarObject = this.calendarObject;
        return clone;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!SeriesReplacement.class.isInstance(other)) {
            return false;
        }
        if (super.merge(other)) {
            SeriesReplacement o = (SeriesReplacement)other;
            this.calendarObject = o.calendarObject;
            this.isTask = o.isTask;
        }
        return false;
    }

    @Override
    public String getReplacement() {
        if (this.calendarObject.getRecurrenceType() == 0) {
            return "";
        }
        String repl = this.format(this.getSeriesString());
        return new StringBuilder(repl.length() + 1).append(repl).append('\n').toString();
    }

    private String getSeriesString() {
        if (this.calendarObject.getRecurrenceType() == 0) {
            return this.getStringHelper().getString("No series");
        }
        StringHelper stringHelper = this.getStringHelper();
        String appendix = this.calendarObject.containsOccurrence() && this.calendarObject.getOccurrence() > 0 ? String.format(stringHelper.getString(this.isTask ? ", ends after %1$s task(s)" : ", ends after %1$s appointment(s)"), this.calendarObject.getOccurrence()) : (!this.calendarObject.containsOccurrence() && this.calendarObject.containsUntil() && this.calendarObject.getUntil() != null ? String.format(stringHelper.getString(", ends on %1$s"), SeriesReplacement.getDateFormat(this.locale).format(this.calendarObject.getUntil())) : "");
        if (this.calendarObject.getRecurrenceType() == 1) {
            if (this.calendarObject.getInterval() == 1) {
                return SeriesReplacement.concat(stringHelper.getString("Each day"), appendix);
            }
            return SeriesReplacement.concat(String.format(stringHelper.getString("Each %1$s days"), this.calendarObject.getInterval()), appendix);
        }
        if (this.calendarObject.getRecurrenceType() == 2) {
            if (this.calendarObject.getInterval() == 1) {
                return SeriesReplacement.concat(String.format(stringHelper.getString("Each week on %1$s"), SeriesReplacement.days2String(this.calendarObject.getDays(), stringHelper)), appendix);
            }
            return SeriesReplacement.concat(String.format(stringHelper.getString("Each %1$s weeks on %2$s"), this.calendarObject.getInterval(), SeriesReplacement.days2String(this.calendarObject.getDays(), stringHelper)), appendix);
        }
        if (this.calendarObject.getRecurrenceType() == 3) {
            if (this.calendarObject.getDays() <= 0) {
                if (this.calendarObject.getInterval() == 1) {
                    return SeriesReplacement.concat(String.format(stringHelper.getString("On %1$s day every month"), SeriesReplacement.ordinal(this.calendarObject.getDayInMonth(), stringHelper)), appendix);
                }
                return SeriesReplacement.concat(String.format(stringHelper.getString("On %1$s day every %2$s month"), SeriesReplacement.ordinal(this.calendarObject.getDayInMonth(), stringHelper), SeriesReplacement.ordinal(this.calendarObject.getInterval(), stringHelper)), appendix);
            }
            if (this.calendarObject.getInterval() == 1) {
                return SeriesReplacement.concat(String.format(stringHelper.getString("On %1$s %2$s each month"), SeriesReplacement.dayInMonth2String(this.calendarObject.getDayInMonth(), stringHelper), SeriesReplacement.days2String(this.calendarObject.getDays(), stringHelper)), appendix);
            }
            return SeriesReplacement.concat(String.format(stringHelper.getString("On %1$s %2$s each %3$s month"), SeriesReplacement.dayInMonth2String(this.calendarObject.getDayInMonth(), stringHelper), SeriesReplacement.days2String(this.calendarObject.getDays(), stringHelper), SeriesReplacement.ordinal(this.calendarObject.getInterval(), stringHelper)), appendix);
        }
        if (this.calendarObject.getRecurrenceType() == 4) {
            if (this.calendarObject.getDays() <= 0) {
                return SeriesReplacement.concat(String.format(stringHelper.getString("Each %1$s %2$s"), SeriesReplacement.ordinal(this.calendarObject.getDayInMonth(), stringHelper), stringHelper.getString(MONTHS[this.calendarObject.getMonth()])), appendix);
            }
            return SeriesReplacement.concat(String.format(stringHelper.getString("On %1$s %2$s in %3$s"), SeriesReplacement.dayInMonth2String(this.calendarObject.getDayInMonth(), stringHelper), SeriesReplacement.days2String(this.calendarObject.getDays(), stringHelper), stringHelper.getString(MONTHS[this.calendarObject.getMonth()])), appendix);
        }
        return "";
    }

    private String format(String seriesStr) {
        String result = String.format(this.getStringHelper().getString("Series: %1$s"), seriesStr);
        if (this.changed) {
            return new StringBuilder("* ".length() + result.length()).append("* ").append(result).toString();
        }
        return result;
    }

    private static final String days2String(int days, StringHelper stringHelper) {
        int msize;
        ArrayList<String> dayStrings = new ArrayList<String>(10);
        if ((days & 2) == 2) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[0]));
        }
        if ((days & 4) == 4) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[1]));
        }
        if ((days & 8) == 8) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[2]));
        }
        if ((days & 0x10) == 16) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[3]));
        }
        if ((days & 0x20) == 32) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[4]));
        }
        if ((days & 0x40) == 64) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[5]));
        }
        if ((days & 1) == 1) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[6]));
        }
        if ((days & 0x7F) == 127) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[7]));
        }
        if ((days & 0x3E) == 62) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[8]));
        }
        if ((days & 0x41) == 65) {
            dayStrings.add(stringHelper.getString(WEEKDAYS[9]));
        }
        if ((msize = dayStrings.size() - 1) == -1) {
            return "";
        }
        if (msize == 0) {
            return (String)dayStrings.get(0);
        }
        StringBuilder b = new StringBuilder((msize + 1) * 9);
        b.append((String)dayStrings.get(0));
        for (int i = 1; i < msize; ++i) {
            b.append(", ").append((String)dayStrings.get(i));
        }
        b.append(' ').append(stringHelper.getString("and")).append(' ').append((String)dayStrings.get(msize));
        return b.toString();
    }

    private static String dayInMonth2String(int dayInMonth, StringHelper stringHelper) {
        return stringHelper.getString(MONTHLY_DAY[dayInMonth - 1]);
    }

    private static String ordinal(int ordinal, StringHelper stringHelper) {
        StringBuilder sb = new StringBuilder(4).append(ordinal);
        if (1 == ordinal) {
            sb.append(stringHelper.getString("st"));
        } else if (2 == ordinal) {
            sb.append(stringHelper.getString("nd"));
        } else if (3 == ordinal) {
            sb.append(stringHelper.getString("rd"));
        } else {
            sb.append(stringHelper.getString("th"));
        }
        return sb.toString();
    }

    private static DateFormat getDateFormat(Locale locale) {
        DateFormat retval = locale == null ? DateFormat.getDateInstance(2, Locale.ENGLISH) : DateFormat.getDateInstance(2, locale);
        retval.setTimeZone(TimeZoneUtils.getTimeZone("UTC"));
        return retval;
    }

    private static String concat(String ... strings) {
        int len = 0;
        for (String string : strings) {
            len += string.length();
        }
        StringBuilder sb = new StringBuilder(len);
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.SERIES;
    }
}

