/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import java.util.Locale;
import java.util.TimeZone;

public abstract class LocalizedStringReplacement
implements TemplateReplacement {
    private StringHelper stringHelper;
    private final TemplateToken token;
    private String replacement;
    protected Locale locale;
    protected boolean changed;

    public LocalizedStringReplacement(TemplateToken token, String replacement) {
        this.token = token;
        this.replacement = replacement;
    }

    public Object clone() throws CloneNotSupportedException {
        LocalizedStringReplacement clone = (LocalizedStringReplacement)super.clone();
        clone.stringHelper = null;
        clone.locale = (Locale)(this.locale == null ? null : this.locale.clone());
        return clone;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    protected final StringHelper getStringHelper() {
        if (this.stringHelper == null) {
            this.stringHelper = this.locale == null ? StringHelper.valueOf(Locale.ENGLISH) : StringHelper.valueOf(this.locale);
        }
        return this.stringHelper;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    public boolean relevantChange() {
        return this.changed();
    }

    @Override
    public String getReplacement() {
        return this.getStringHelper().getString(this.replacement);
    }

    @Override
    public TemplateToken getToken() {
        return this.token;
    }

    @Override
    public TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public final TemplateReplacement setLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return this;
        }
        this.locale = locale;
        this.stringHelper = null;
        return this;
    }

    @Override
    public TemplateReplacement setTimeZone(TimeZone timeZone) {
        return this;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!LocalizedStringReplacement.class.isInstance(other)) {
            return false;
        }
        if (!this.getToken().equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        LocalizedStringReplacement o = (LocalizedStringReplacement)other;
        this.replacement = o.replacement;
        this.changed = true;
        return true;
    }
}

