/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools;

import com.openexchange.i18n.I18nService;
import com.openexchange.server.services.I18nServices;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelper {
    private static final Logger LOG = LoggerFactory.getLogger(StringHelper.class);
    private static final ConcurrentMap<Locale, StringHelper> CACHE = new ConcurrentHashMap<Locale, StringHelper>();
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private final Locale locale;

    public static StringHelper valueOf(Locale locale) {
        StringHelper newHelper;
        Locale loc = null == locale ? DEFAULT_LOCALE : locale;
        StringHelper sh = (StringHelper)CACHE.get(loc);
        if (null == sh && null == (sh = CACHE.putIfAbsent(loc, newHelper = new StringHelper(loc)))) {
            sh = newHelper;
        }
        return sh;
    }

    private StringHelper(Locale locale) {
        this.locale = locale;
    }

    public final String getString(String key) {
        if (null == this.locale) {
            return key;
        }
        try {
            I18nService tool = I18nServices.getInstance().getService(this.locale);
            if (tool == null) {
                LOG.debug("No service for {}  found. Using default for bundle ", (Object)this.locale);
                return key;
            }
            return tool.getLocalized(key);
        }
        catch (MissingResourceException x) {
            LOG.debug("MissingResource for {}. Using default for bundle ", (Object)this.locale, (Object)x);
            return key;
        }
    }

    public int hashCode() {
        return this.locale == null ? 0 : this.locale.getClass().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StringHelper) {
            StringHelper sh = (StringHelper)o;
            if (this.locale == null && sh.locale == null) {
                return true;
            }
            if (this.locale == null && sh.locale != null) {
                return false;
            }
            if (this.locale != null && sh.locale == null) {
                return false;
            }
            return sh.locale.equals(this.locale);
        }
        return false;
    }
}

