/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.Permission;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import java.util.List;
import java.util.Set;

public class MutableUserConfiguration
extends UserConfiguration {
    private static final long serialVersionUID = 1L;

    public MutableUserConfiguration(Set<String> capabilities, int userId, int[] groups, Context ctx) {
        super(capabilities, userId, groups, ctx);
    }

    public void setWebMail(boolean enableWebMail) {
        this.setPermission(enableWebMail, 1);
    }

    public void setCalendar(boolean enableCalender) {
        this.setPermission(enableCalender, 2);
    }

    public void setContact(boolean enableContact) {
        this.setPermission(enableContact, 4);
    }

    public void setTask(boolean enableTask) {
        this.setPermission(enableTask, 8);
    }

    public void setInfostore(boolean enableInfostore) {
        this.setPermission(enableInfostore, 16);
    }

    public void setProject(boolean enableProject) {
        this.setPermission(enableProject, 32);
    }

    public void setForum(boolean enableForum) {
        this.setPermission(enableForum, 64);
    }

    public void setPinboardWriteAccess(boolean enablePinboardWriteAccess) {
        this.setPermission(enablePinboardWriteAccess, 128);
    }

    public void setWebDAVXML(boolean enableWebDAVXML) {
        this.setPermission(enableWebDAVXML, 256);
    }

    public void setWebDAV(boolean enableWebDAV) {
        this.setPermission(enableWebDAV, 512);
    }

    public void setICal(boolean enableICal) {
        this.setPermission(enableICal, 1024);
    }

    public void setVCard(boolean enableVCard) {
        this.setPermission(enableVCard, 2048);
    }

    public void setRSSBookmarks(boolean enableRSSBookmarks) {
        this.setPermission(enableRSSBookmarks, 4096);
    }

    public void setRSSPortal(boolean enableRSSPortal) {
        this.setPermission(enableRSSPortal, 8192);
    }

    public void setSyncML(boolean enableSyncML) {
        this.setPermission(enableSyncML, 16384);
    }

    public void setDeniedPortal(boolean deniedPortal) {
        this.setPermission(deniedPortal, 0x10000000);
    }

    public void setFullPublicFolderAccess(boolean enableFullPublicFolderAccess) {
        this.setPermission(enableFullPublicFolderAccess, 32768);
    }

    public void setFullSharedFolderAccess(boolean enableFullSharedFolderAccess) {
        this.setPermission(enableFullSharedFolderAccess, 65536);
    }

    public void setDelegateTasks(boolean enableDelegateTasks) {
        this.setPermission(enableDelegateTasks, 131072);
    }

    public void setCollectEmailAddresses(boolean collectEmailAddresses) {
        this.setPermission(collectEmailAddresses, 0x200000);
    }

    public void setMultipleMailAccounts(boolean multipleMailAccounts) {
        this.setPermission(multipleMailAccounts, 0x400000);
    }

    public void setSubscription(boolean subscription) {
        this.setPermission(subscription, 0x800000);
    }

    public void setPublication(boolean publication) {
        this.setPermission(publication, 0x1000000);
    }

    public void setActiveSync(boolean eas) {
        this.setPermission(eas, 0x2000000);
    }

    public void setUSM(boolean usm) {
        this.setPermission(usm, 0x4000000);
    }

    public void setOLOX20(boolean olox20) {
        this.setPermission(olox20, 0x8000000);
    }

    public void setEditGroup(boolean editGroup) {
        this.setPermission(editGroup, 262144);
    }

    public void setEditResource(boolean editResource) {
        this.setPermission(editResource, 524288);
    }

    public void setEditPassword(boolean editPassword) {
        this.setPermission(editPassword, 0x100000);
    }

    private void setPermission(boolean enable, int permission) {
        List<Permission> byBits = Permission.byBits(permission);
        if (enable) {
            for (Permission p : byBits) {
                this.capabilities.add(p.name().toLowerCase());
            }
        } else {
            for (Permission p : byBits) {
                this.capabilities.remove(p.name().toLowerCase());
            }
        }
    }

    public static int getPermissionBits(Set<String> capabilities) {
        return 0;
    }
}

