/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.CachingUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.RdbUserPermissionBitsStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingUserPermissionBitsStorage
extends UserPermissionBitsStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CachingUserConfigurationStorage.class);
    private static final String CACHE_REGION_NAME = "UserPermissionBits";
    private final CacheAvailabilityListener cacheAvailabilityListener;
    private final transient UserPermissionBitsStorage delegateStorage = new RdbUserPermissionBitsStorage();
    private volatile Cache cache;
    private volatile UserPermissionBitsStorage fallback;

    public CachingUserPermissionBitsStorage() throws OXException {
        this.cacheAvailabilityListener = new CacheAvailabilityListener(){

            @Override
            public void handleAbsence() throws OXException {
                CachingUserPermissionBitsStorage.this.releaseCache();
            }

            @Override
            public void handleAvailability() throws OXException {
                CachingUserPermissionBitsStorage.this.initCache();
            }
        };
        this.initCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPermissionBitsStorage getFallback() {
        UserPermissionBitsStorage fallback = this.fallback;
        if (null == fallback) {
            CachingUserPermissionBitsStorage cachingUserPermissionBitsStorage = this;
            synchronized (cachingUserPermissionBitsStorage) {
                fallback = this.fallback;
                if (null == fallback) {
                    this.fallback = fallback = new RdbUserPermissionBitsStorage();
                }
            }
        }
        return fallback;
    }

    @Override
    protected void startInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg && !reg.registerListener(this.cacheAvailabilityListener)) {
            LOG.error("Cache availability listener could not be registered", new Throwable());
        }
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this.cacheAvailabilityListener);
        }
        this.releaseCache();
    }

    private static final CacheKey getKey(int userId, Context ctx, Cache cache) {
        return cache.newCacheKey(ctx.getContextId(), userId);
    }

    private static final CacheKey getKey(int userId, int contextId, Cache cache) {
        return cache.newCacheKey(contextId, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCache() throws OXException {
        Cache cache = this.cache;
        if (null == cache) {
            CachingUserPermissionBitsStorage cachingUserPermissionBitsStorage = this;
            synchronized (cachingUserPermissionBitsStorage) {
                cache = this.cache;
                if (null == cache) {
                    try {
                        this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_REGION_NAME);
                    }
                    catch (RuntimeException e) {
                        throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
                    }
                }
            }
        }
    }

    void releaseCache() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        try {
            cache.clear();
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(CACHE_REGION_NAME);
            }
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public UserPermissionBits getUserPermissionBits(int userId, int contextId) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserPermissionBits(userId, contextId);
        }
        return this.get(cache, contextId, userId);
    }

    @Override
    public UserPermissionBits getUserPermissionBits(int userId, Context ctx) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserPermissionBits(userId, ctx);
        }
        return this.get(cache, ctx, userId);
    }

    @Override
    public UserPermissionBits[] getUserPermissionBits(Context ctx, User[] users) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserPermissionBits(ctx, users);
        }
        int[] userIds = new int[users.length];
        for (int i = 0; i < users.length; ++i) {
            userIds[i] = users[i].getId();
        }
        return this.get(cache, ctx, userIds);
    }

    @Override
    public UserPermissionBits[] getUserPermissionBits(Context ctx, int[] userIds) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserPermissionBits(ctx, userIds);
        }
        return this.get(cache, ctx, userIds);
    }

    @Override
    public void clearStorage() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        try {
            cache.clear();
        }
        catch (RuntimeException rte) {
            LOG.warn("A runtime error occurred.", (Throwable)rte);
        }
    }

    @Override
    public void removeUserPermissionBits(int userId, Context ctx) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        cache.remove((Serializable)CachingUserPermissionBitsStorage.getKey(userId, ctx, cache));
    }

    @Override
    public void saveUserPermissionBits(int permissionBits, int userId, Context ctx) throws OXException {
        this.delegateStorage.saveUserPermissionBits(permissionBits, userId, ctx);
        this.removeUserPermissionBits(userId, ctx);
    }

    private UserPermissionBits get(Cache cache, int contextId, int userId) throws OXException {
        CacheKey key = CachingUserPermissionBitsStorage.getKey(userId, contextId, cache);
        Object object = cache.get((Serializable)key);
        if (object != null) {
            return ((UserPermissionBits)object).clone();
        }
        ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class);
        if (null == contextService) {
            throw ServiceExceptionCode.absentService(ContextService.class);
        }
        return this.load(cache, contextService.getContext(contextId), userId);
    }

    private UserPermissionBits get(Cache cache, Context ctx, int userId) throws OXException {
        CacheKey key = CachingUserPermissionBitsStorage.getKey(userId, ctx, cache);
        Object object = cache.get((Serializable)key);
        if (object != null) {
            return ((UserPermissionBits)object).clone();
        }
        return this.load(cache, ctx, userId);
    }

    private UserPermissionBits load(Cache cache, Context ctx, int userId) throws OXException {
        UserPermissionBits perm = this.delegateStorage.getUserPermissionBits(userId, ctx);
        cache.put((Serializable)CachingUserPermissionBitsStorage.getKey(userId, ctx, cache), (Serializable)perm.clone(), false);
        return perm;
    }

    private UserPermissionBits[] get(Cache cache, Context ctx, int[] userIds) throws OXException {
        if (userIds.length == 0) {
            return new UserPermissionBits[0];
        }
        TIntObjectHashMap map = new TIntObjectHashMap(userIds.length);
        TIntArrayList toLoad = new TIntArrayList(userIds.length);
        for (int id : userIds) {
            CacheKey key = CachingUserPermissionBitsStorage.getKey(id, ctx, cache);
            Object object = cache.get((Serializable)key);
            if (object == null) {
                toLoad.add(id);
                continue;
            }
            map.put(id, (Object)((UserPermissionBits)object).clone());
        }
        if (!toLoad.isEmpty()) {
            for (UserPermissionBits perms : this.load(cache, ctx, (TIntList)toLoad)) {
                map.put(perms.getUserId(), (Object)perms);
            }
        }
        UserPermissionBits[] userPermissionBitsArray = new UserPermissionBits[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            userPermissionBitsArray[i] = (UserPermissionBits)map.get(userIds[i]);
        }
        return userPermissionBitsArray;
    }

    private UserPermissionBits[] load(Cache cache, Context ctx, TIntList userIds) throws OXException {
        UserPermissionBits[] perms;
        for (UserPermissionBits userPermissionBits : perms = this.delegateStorage.getUserPermissionBits(ctx, userIds.toArray())) {
            cache.put((Serializable)CachingUserPermissionBitsStorage.getKey(userPermissionBits.getUserId(), ctx, cache), (Serializable)userPermissionBits.clone(), false);
        }
        return perms;
    }
}

