/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnboundFolderReplacementUpdateTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(UnboundFolderReplacementUpdateTask.class);
    private static final String STR_INFO = "Performing update task 'UnboundFolderReplacementUpdateTask'";
    private static final String TABLE_WORKING = "oxfolder_tree";
    private static final String TABLE_BACKUP = "del_oxfolder_tree";
    private static final String TABLE_REPL = "#TABLE#";
    private static final String SQL_UPDATE = "UPDATE #TABLE# AS ot SET ot.module = 3 WHERE ot.module = 4";

    @Override
    public int addedWithVersion() {
        return 5;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info(STR_INFO);
        }
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = Database.get(contextId, true);
            try {
                stmt = writeCon.prepareStatement(SQL_UPDATE.replaceFirst(TABLE_REPL, TABLE_WORKING));
                stmt.executeUpdate();
                stmt.close();
                stmt = writeCon.prepareStatement(SQL_UPDATE.replaceFirst(TABLE_REPL, TABLE_BACKUP));
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (writeCon != null) {
            Database.back(contextId, true, writeCon);
        }
    }
}

