/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskModifiedByNotNull
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(TaskModifiedByNotNull.class);
    private final String task_table = SQL.TASK_TABLES.get((Object)StorageType.ACTIVE);
    private final String del_task_table = SQL.TASK_TABLES.get((Object)StorageType.DELETED);
    private final String changed_from = Mapping.getMapping(3).getDBColumnName();
    private final String created_from = Mapping.getMapping(2).getDBColumnName();

    @Override
    public int addedWithVersion() {
        return 2;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        LOG.info("Performing update task TaskModifiedByNotNull.");
        Connection con = null;
        try {
            con = Database.get(contextId, true);
        }
        catch (OXException e) {
            throw TaskExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        try {
            if (Tools.isNullable(con, this.task_table, this.changed_from)) {
                this.setModifiedBy(con, this.task_table);
                this.alterModifiedBy(con, this.task_table);
            }
            if (Tools.isNullable(con, this.del_task_table, this.changed_from)) {
                this.setModifiedBy(con, this.del_task_table);
                this.alterModifiedBy(con, this.del_task_table);
            }
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setModifiedBy(Connection con, String table) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            int updated = stmt.executeUpdate("UPDATE " + table + " SET " + this.changed_from + '=' + this.created_from + " WHERE " + this.changed_from + " IS NULL");
            LOG.info("Updated in {} rows {} to {} in table {}", new Object[]{updated, this.changed_from, this.created_from, table});
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterModifiedBy(Connection con, String table) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute("ALTER TABLE " + table + " MODIFY " + this.changed_from + " INT4 UNSIGNED NOT NULL");
            LOG.info("Altered table {} changed {} to NOT NULL.", (Object)table, (Object)this.changed_from);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }
}

