/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class RemoveRedundantKeysForBug26913UpdateTask
extends UpdateTaskAdapter {
    private static final String[] INDEX_COLUMNS = new String[]{"cid", "user"};
    private static final String SNIPPET_TABLE = "snippet";
    private static final String PREVIEW_TABLE = "preview";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            String snippetKey;
            con.setAutoCommit(false);
            String previewKey = Tools.existsIndex(con, PREVIEW_TABLE, INDEX_COLUMNS);
            if (previewKey != null && previewKey.equals("user")) {
                Tools.dropIndex(con, PREVIEW_TABLE, previewKey);
            }
            if ((snippetKey = Tools.existsIndex(con, SNIPPET_TABLE, INDEX_COLUMNS)) != null && snippetKey.equals("indexUser")) {
                Tools.dropIndex(con, SNIPPET_TABLE, snippetKey);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

