/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordMechUpdateTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordMechUpdateTask.class);
    private static final String SQL_MODIFY = "ALTER TABLE user ADD COLUMN passwordMech VARCHAR(32) NOT NULL";
    private static final String SQL_UPDATE = "UPDATE user SET passwordMech = ?";
    private static final String SHA = "{SHA}";
    private static final String STR_INFO = "Performing update task 'PasswordMechUpdateTask'";
    private static final String SQL_SELECT_ALL = "SELECT * FROM user";
    private static final String COLUMN = "passwordMech";

    @Override
    public int addedWithVersion() {
        return 1;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info(STR_INFO);
        }
        if (PasswordMechUpdateTask.checkColumn(contextId)) {
            return;
        }
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = Database.get(contextId, true);
            try {
                stmt = writeCon.prepareStatement(SQL_MODIFY);
                stmt.executeUpdate();
                stmt.close();
                stmt = writeCon.prepareStatement(SQL_UPDATE);
                stmt.setString(1, SHA);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (writeCon != null) {
            Database.back(contextId, true, writeCon);
        }
    }

    /*
     * Loose catch block
     */
    private static final boolean checkColumn(int contextId) throws OXException {
        Connection readCon = null;
        Statement stmt = null;
        ResultSet rs = null;
        readCon = Database.get(contextId, false);
        stmt = readCon.createStatement();
        rs = stmt.executeQuery(SQL_SELECT_ALL);
        ResultSetMetaData meta = rs.getMetaData();
        int length = meta.getColumnCount();
        boolean found = false;
        for (int i = 1; i <= length && !found; ++i) {
            found = COLUMN.equals(meta.getColumnName(i));
        }
        boolean bl = found;
        DBUtils.closeSQLStuff(rs, stmt);
        if (readCon != null) {
            Database.back(contextId, false, readCon);
        }
        return bl;
        {
            catch (SQLException e) {
                try {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (readCon != null) {
                        Database.back(contextId, false, readCon);
                    }
                    throw throwable;
                }
            }
        }
    }
}

