/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailUploadQuotaUpdateTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(MailUploadQuotaUpdateTask.class);
    private static final String STR_INFO = "Performing update task 'MailUploadQuotaUpdateTask'";
    private static final String SQL_MODIFY01 = "ALTER TABLE user_setting_mail MODIFY `upload_quota` INT4 DEFAULT -1";
    private static final String SQL_MODIFY02 = "ALTER TABLE user_setting_mail MODIFY `upload_quota_per_file` INT4 DEFAULT -1";

    @Override
    public int addedWithVersion() {
        return 6;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info(STR_INFO);
        }
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = Database.get(contextId, true);
            try {
                stmt = writeCon.prepareStatement(SQL_MODIFY01);
                stmt.executeUpdate();
                stmt.close();
                stmt = writeCon.prepareStatement(SQL_MODIFY02);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (writeCon != null) {
            Database.back(contextId, true, writeCon);
        }
    }
}

