/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderExtendNameTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(FolderExtendNameTask.class);
        String simpleName = FolderExtendNameTask.class.getSimpleName();
        log.info("Performing update task {}", (Object)simpleName);
        Connection connnection = Database.getNoTimeout(params.getContextId(), true);
        boolean rollback = false;
        try {
            connnection.setAutoCommit(false);
            rollback = true;
            this.enlargeVarcharColumn("fname", 767, "oxfolder_tree", connnection);
            this.enlargeVarcharColumn("name", 767, "virtualTree", connnection);
            connnection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connnection);
            }
            DBUtils.autocommit(connnection);
            Database.backNoTimeout(params.getContextId(), true, connnection);
        }
        log.info("{} successfully performed.", (Object)simpleName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enlargeVarcharColumn(String colName, int newSize, String tableName, Connection con) throws OXException {
        ResultSet rsColumns = null;
        boolean doAlterTable = false;
        try {
            DatabaseMetaData meta = con.getMetaData();
            rsColumns = meta.getColumns(null, null, tableName, null);
            while (rsColumns.next()) {
                String columnName = rsColumns.getString("COLUMN_NAME");
                if (!colName.equals(columnName)) continue;
                int size = rsColumns.getInt("COLUMN_SIZE");
                if (size >= newSize) break;
                doAlterTable = true;
                break;
            }
            Databases.closeSQLStuff((ResultSet)rsColumns);
            rsColumns = null;
            if (doAlterTable) {
                Tools.modifyColumns(con, tableName, new Column(colName, "VARCHAR(" + newSize + ")"));
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw UpdateExceptionCodes.OTHER_PROBLEM.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rsColumns);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rsColumns);
    }
}

