/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class FolderDefaultValuesForDelTablesTasks
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = databaseService.getForUpdateTask(contextID);
        boolean rollback = false;
        try {
            PreparedStatement stmt;
            connection.setAutoCommit(false);
            rollback = true;
            if (!Tools.hasDefaultValue(connection, "del_oxfolder_tree", "fname")) {
                stmt = null;
                try {
                    stmt = connection.prepareStatement("ALTER TABLE del_oxfolder_tree ALTER COLUMN fname SET DEFAULT ''");
                    stmt.executeUpdate();
                }
                finally {
                    DBUtils.closeSQLStuff(stmt);
                }
            }
            if (!Tools.hasDefaultValue(connection, "virtualBackupTree", "name")) {
                stmt = null;
                try {
                    stmt = connection.prepareStatement("ALTER TABLE virtualBackupTree ALTER COLUMN name SET DEFAULT ''");
                    stmt.executeUpdate();
                }
                finally {
                    DBUtils.closeSQLStuff(stmt);
                }
            }
            connection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(contextID, true, connection);
        }
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }
}

