/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnlargeTaskTitle
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(EnlargeTaskTitle.class);
    private final String title = Mapping.getMapping(200).getDBColumnName();

    @Override
    public int addedWithVersion() {
        return 18;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        LOG.info("Performing update task EnlargeTaskTitle.");
        Connection con = Database.get(contextId, true);
        try {
            for (StorageType type : StorageType.TYPES_AD) {
                this.alterTitle(con, SQL.TASK_TABLES.get((Object)type));
            }
        }
        catch (SQLException e) {
            throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            Database.back(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterTitle(Connection con, String table) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute("ALTER TABLE " + table + " MODIFY " + this.title + " VARCHAR(256)");
            LOG.info("Altered table {} changed {} to VARCHAR(256).", (Object)table, (Object)this.title);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }
}

