/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.ForeignKeyOld;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearOrphanedInfostoreDocuments
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(ClearOrphanedInfostoreDocuments.class);

    @Override
    public int addedWithVersion() {
        return 26;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        PreparedStatement select = null;
        PreparedStatement delete = null;
        PreparedStatement addKey = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            LOG.info("Clearing orphaned infostore document versions");
            con = Database.getNoTimeout(contextId, true);
            List<ForeignKeyOld> keys = ForeignKeyOld.getForeignKeys(con, "infostore_document");
            ForeignKeyOld fk = new ForeignKeyOld("infostore_document", "infostore_id", "infostore", "id");
            if (keys.contains(fk)) {
                LOG.info("Foreign Key {} exists. Skipping Update Task.", (Object)fk);
                return;
            }
            con.setAutoCommit(false);
            select = con.prepareStatement("SELECT doc.cid, doc.infostore_id, doc.version_number, doc.file_store_location FROM infostore_document AS doc LEFT JOIN infostore AS info ON info.cid = doc.cid AND info.id = doc.infostore_id WHERE info.id IS NULL");
            delete = con.prepareStatement("DELETE FROM infostore_document WHERE cid = ? AND infostore_id = ? AND version_number = ?");
            addKey = con.prepareStatement("ALTER TABLE infostore_document ADD FOREIGN KEY (cid, infostore_id) REFERENCES infostore (cid, id)");
            rs = select.executeQuery();
            int counter = 0;
            while (rs.next()) {
                int cid = rs.getInt(1);
                int id = rs.getInt(2);
                int version2 = rs.getInt(3);
                String fileStoreLocation = rs.getString(4);
                delete.setInt(1, cid);
                delete.setInt(2, id);
                delete.setInt(3, version2);
                delete.executeUpdate();
                if (null != fileStoreLocation) {
                    Tools.removeFile(cid, fileStoreLocation);
                } else if (0 != version2) {
                    LOG.warn("Found file version without location in filestore. cid:{},id:{},version:{}.", new Object[]{cid, id, version2});
                }
                ++counter;
            }
            LOG.info("Cleared {} orphaned documents", (Object)counter);
            LOG.info("Adding foreign key: {}", (Object)fk);
            addKey.executeUpdate();
            con.commit();
            DBUtils.closeSQLStuff(rs, select);
        }
        catch (SQLException e) {
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            LOG.error("", (Throwable)e);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(rs, select);
            DBUtils.closeSQLStuff(null, delete);
            DBUtils.closeSQLStuff(null, addKey);
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
        DBUtils.closeSQLStuff(null, delete);
        DBUtils.closeSQLStuff(null, addKey);
        DBUtils.autocommit(con);
        Database.backNoTimeout(contextId, true, con);
    }
}

