/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppointmentChangedFromZeroTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentChangedFromZeroTask.class);

    @Override
    public int addedWithVersion() {
        return 21;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException, OXException {
        LOG.info("Performing update task to remove 0 set changed_from in appointments.");
        Connection con = Database.get(contextId, true);
        Statement st = null;
        try {
            con.setAutoCommit(false);
            st = con.createStatement();
            st.executeUpdate("UPDATE prg_dates SET changed_from=created_from WHERE changed_from=0");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            DBUtils.closeSQLStuff(null, st);
            if (con != null) {
                Database.back(contextId, true, con);
            }
        }
        LOG.info("Update task to remove 0 set changed_from in appointments performed.");
    }
}

