/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterUidCollation
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(AlterUidCollation.class);
    private static final String SQL = "ALTER TABLE login2user MODIFY uid VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL";
    private static final String USER = "INSERT INTO user (cid,id,mail,mailEnabled,preferredLanguage,shadowLastChange,timeZone,contactId,passwordMech,uidNumber,gidNumber,homeDirectory,loginShell) VALUES (2147483647,2147483647,'',false,'',0,'',0,'',0,0,'','')";
    private static final String UMLAUTS = "INSERT INTO login2user (cid,id,uid) VALUES (2147483647,2147483647,'\u00e4\u00f6\u00fc')";
    private static final String DUPLICATE = "INSERT INTO login2user (cid,id,uid) VALUES (2147483647,2147483647,'aou')";

    @Override
    public int addedWithVersion() {
        return 60;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            if (this.doUmlautsWork(con)) {
                LOG.info("Collation allows inserting '\u00e4\u00f6\u00fc' and 'aou'.");
                return;
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        LOG.info("Changing collation to allow inserting '\u00e4\u00f6\u00fc' and 'aou'.");
        Statement stmt = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            stmt.execute(SQL);
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit(con);
                Database.backNoTimeout(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        DBUtils.autocommit(con);
        Database.backNoTimeout(contextId, true, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUmlautsWork(Connection con) throws SQLException {
        boolean retval = true;
        Statement stmt = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            stmt.execute(USER);
            stmt.execute(UMLAUTS);
            try {
                stmt.execute(DUPLICATE);
            }
            catch (SQLException e) {
                retval = false;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            DBUtils.rollback(con);
            DBUtils.autocommit(con);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
        DBUtils.rollback(con);
        DBUtils.autocommit(con);
        return retval;
    }
}

