/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.SeparatedTasks;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.DynamicList;
import com.openexchange.groupware.update.internal.ExcludedList;
import com.openexchange.groupware.update.internal.ExecutedFilter;
import com.openexchange.groupware.update.internal.SchemaUpdateStateImpl;
import com.openexchange.groupware.update.internal.UpdateTaskSorter;
import com.openexchange.groupware.update.internal.VersionFilter;
import com.openexchange.java.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateTaskCollection {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTaskCollection.class);
    private static final UpdateTaskCollection SINGLETON = new UpdateTaskCollection();
    private int version;
    private final AtomicBoolean versionDirty = new AtomicBoolean(true);

    private UpdateTaskCollection() {
    }

    static UpdateTaskCollection getInstance() {
        return SINGLETON;
    }

    void dispose() {
        this.versionDirty.set(true);
    }

    private final List<UpdateTask> getFilteredUpdateTasks(SchemaUpdateState schema) {
        List<UpdateTask> tasks2 = this.getListWithoutExcludes();
        SchemaUpdateState state = this.addExecutedBasedOnVersion(schema, tasks2);
        ExecutedFilter filter = new ExecutedFilter();
        ArrayList<UpdateTask> filtered = new ArrayList<UpdateTask>();
        for (UpdateTask task : tasks2) {
            if (!filter.mustBeExecuted(state, task)) continue;
            filtered.add(task);
        }
        return filtered;
    }

    SeparatedTasks getFilteredAndSeparatedTasks(SchemaUpdateState state) {
        return this.separateTasks(this.getFilteredUpdateTasks(state));
    }

    SeparatedTasks separateTasks(List<UpdateTask> tasks2) {
        final ArrayList<UpdateTask> blocking = new ArrayList<UpdateTask>();
        final ArrayList<UpdateTaskV2> background = new ArrayList<UpdateTaskV2>();
        for (UpdateTask toExecute : tasks2) {
            if (toExecute instanceof UpdateTaskV2) {
                UpdateTaskV2 toExecuteV2 = (UpdateTaskV2)toExecute;
                switch (toExecuteV2.getAttributes().getConcurrency()) {
                    case BLOCKING: {
                        blocking.add(toExecuteV2);
                        break;
                    }
                    case BACKGROUND: {
                        background.add(toExecuteV2);
                        break;
                    }
                    default: {
                        OXException e = UpdateExceptionCodes.UNKNOWN_CONCURRENCY.create(toExecuteV2.getClass().getName());
                        LOG.error("", (Throwable)e);
                        blocking.add(toExecuteV2);
                        break;
                    }
                }
                continue;
            }
            blocking.add(toExecute);
        }
        return new SeparatedTasks(){

            @Override
            public List<UpdateTask> getBlocking() {
                return blocking;
            }

            @Override
            public List<UpdateTaskV2> getBackground() {
                return background;
            }
        };
    }

    final List<UpdateTask> getFilteredAndSortedUpdateTasks(SchemaUpdateState schema, boolean blocking) throws OXException {
        SeparatedTasks tasks2 = this.getFilteredAndSeparatedTasks(schema);
        List<UpdateTask> retval = new ArrayList<UpdateTask>();
        if (blocking) {
            retval.addAll(tasks2.getBlocking());
        } else {
            if (tasks2.getBlocking().size() > 0) {
                throw UpdateExceptionCodes.BLOCKING_FIRST.create(Strings.join(tasks2.getBlocking(), (String)","), Strings.join(tasks2.getBackground(), (String)","));
            }
            retval.addAll(tasks2.getBackground());
        }
        SchemaUpdateState simulatedState = this.addExecutedBasedOnVersion(schema, this.getListWithoutExcludes());
        retval = new UpdateTaskSorter().sort(simulatedState.getExecutedList(), retval);
        return retval;
    }

    private SchemaUpdateState addExecutedBasedOnVersion(SchemaUpdateState schema, List<UpdateTask> tasks2) {
        SchemaUpdateState retval;
        if (200 != schema.getDBVersion() && -1 != schema.getDBVersion()) {
            retval = new SchemaUpdateStateImpl(schema);
            VersionFilter filter = new VersionFilter();
            for (UpdateTask task : tasks2) {
                if (filter.mustBeExecuted(schema, task)) continue;
                retval.addExecutedTask(task.getClass().getName());
            }
        } else {
            retval = schema;
        }
        return retval;
    }

    final int getHighestVersion() {
        if (this.versionDirty.get()) {
            List<UpdateTask> tasks2 = this.getListWithoutExcludes();
            int vers = 0;
            for (UpdateTask task : tasks2) {
                vers = Math.max(vers, task.addedWithVersion());
            }
            this.version = vers;
            this.versionDirty.set(true);
        }
        return this.version;
    }

    List<UpdateTask> getListWithoutExcludes() {
        List<UpdateTask> retval = this.getFullList();
        for (String excluded : ExcludedList.getInstance().getTaskList()) {
            Iterator<UpdateTask> iter = retval.iterator();
            while (iter.hasNext()) {
                if (!excluded.equals(iter.next().getClass().getName())) continue;
                iter.remove();
            }
        }
        return retval;
    }

    private List<UpdateTask> getFullList() {
        return DynamicList.getInstance().getTaskList();
    }

    void dirtyVersion() {
        this.versionDirty.set(true);
    }

    boolean needsUpdate(SchemaUpdateState state) {
        if (this.getHighestVersion() > state.getDBVersion()) {
            return true;
        }
        List<UpdateTask> tasks2 = this.getListWithoutExcludes();
        for (UpdateTask task : tasks2) {
            if (state.isExecuted(task.getClass().getName())) continue;
            return true;
        }
        return false;
    }
}

