/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.internal.UpdateExecutor;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProcess
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateProcess.class);
    private final int contextId;
    private final SchemaStore schemaStore = SchemaStore.getInstance();

    public UpdateProcess(int contextId) {
        this.contextId = contextId;
    }

    @Override
    public void run() {
        try {
            SchemaUpdateState state = this.schemaStore.getSchema(this.contextId);
            if (!UpdateTaskCollection.getInstance().needsUpdate(state)) {
                return;
            }
            new UpdateExecutor(state, this.contextId, null).execute();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error("", t);
        }
    }
}

