/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.ExecutedTask;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.internal.CreateUpdateTaskTable;
import com.openexchange.groupware.update.internal.ExecutedTaskImpl;
import com.openexchange.groupware.update.internal.SchemaExceptionCodes;
import com.openexchange.groupware.update.internal.SchemaImpl;
import com.openexchange.groupware.update.internal.SchemaUpdateStateImpl;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.caching.SerializedCachingLoader;
import com.openexchange.tools.caching.StorageLoader;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaStoreImpl
extends SchemaStore {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaStoreImpl.class);
    private static final String CACHE_REGION = "OXDBPoolCache";
    private static final String TABLE_NAME = "updateTask";
    private static final String LOCKED = "LOCKED";
    private static final String BACKGROUND = "BACKGROUND";
    final Lock cacheLock = new ReentrantLock();
    Cache cache;
    private static final int MYSQL_DEADLOCK = 1213;
    private static final int MYSQL_DUPLICATE = 1062;

    @Override
    protected SchemaUpdateState getSchema(final int poolId, final String schemaName, final Connection con) throws OXException {
        return SerializedCachingLoader.fetch(this.cache, CACHE_REGION, null, this.cacheLock, new StorageLoader<SchemaUpdateState>(){

            @Override
            public Serializable getKey() {
                return SchemaStoreImpl.this.cache.newCacheKey(poolId, new Serializable[]{schemaName});
            }

            @Override
            public SchemaUpdateState load() throws OXException {
                return SchemaStoreImpl.loadSchema(con);
            }
        });
    }

    static SchemaUpdateState loadSchema(Connection con) throws OXException {
        SchemaUpdateState retval;
        try {
            con.setAutoCommit(false);
            SchemaStoreImpl.checkForTable(con);
            retval = SchemaStoreImpl.loadSchemaStatus(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
        }
        return retval;
    }

    private static void checkForTable(Connection con) throws SQLException {
        if (!Tools.tableExists(con, TABLE_NAME)) {
            SchemaStoreImpl.createTable(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTable(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(CreateUpdateTaskTable.CREATES[0]);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    @Override
    public void lockSchema(Schema schema, int contextId, boolean background) throws OXException {
        int poolId = Database.resolvePool(contextId, true);
        CacheKey key = null;
        if (null != this.cache) {
            key = this.cache.newCacheKey(poolId, new Serializable[]{schema.getSchema()});
            try {
                this.cache.remove((Serializable)key);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        SchemaStoreImpl.lockSchemaDB(schema, contextId, background);
        if (null != this.cache && null != key) {
            try {
                this.cache.remove((Serializable)key);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static void lockSchemaDB(Schema schema, int contextId, boolean background) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            con.setAutoCommit(false);
            SchemaStoreImpl.insertLock(con, schema, background ? BACKGROUND : LOCKED);
            if (Tools.tableExists(con, "version") && !background) {
                SchemaStoreImpl.lockOldVersionTable(con, schema);
            }
            con.commit();
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    private static void insertLock(Connection con, Schema schema, String idiom) throws SQLException, OXException {
        if (SchemaStoreImpl.hasUUID(con)) {
            SchemaStoreImpl.insertLockUUID(con, schema, idiom);
        } else {
            SchemaStoreImpl.insertLockNoUUID(con, schema, idiom);
        }
    }

    private static void insertLockNoUUID(Connection con, Schema schema, String idiom) throws OXException {
        ExecutedTask[] tasks2;
        for (ExecutedTask task : tasks2 = SchemaStoreImpl.readUpdateTasks(con)) {
            if (!idiom.equals(task.getTaskName())) continue;
            throw SchemaExceptionCodes.ALREADY_LOCKED.create(schema.getSchema());
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO updateTask (cid,taskName,successful,lastModified) VALUES (0,?,true,?)");
            stmt.setString(1, idiom);
            stmt.setLong(2, System.currentTimeMillis());
            if (stmt.executeUpdate() == 0) {
                throw SchemaExceptionCodes.LOCK_FAILED.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            if (1213 == e.getErrorCode() || 1062 == e.getErrorCode()) {
                throw SchemaExceptionCodes.ALREADY_LOCKED.create(e, schema.getSchema());
            }
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static void insertLockUUID(Connection con, Schema schema, String idiom) throws OXException {
        ExecutedTask[] tasks2;
        for (ExecutedTask task : tasks2 = SchemaStoreImpl.readUpdateTasks(con)) {
            if (!idiom.equals(task.getTaskName())) continue;
            throw SchemaExceptionCodes.ALREADY_LOCKED.create(schema.getSchema());
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO updateTask (cid,taskName,successful,lastModified,uuid) VALUES (0,?,true,?,?)");
            stmt.setString(1, idiom);
            stmt.setLong(2, System.currentTimeMillis());
            stmt.setBytes(3, SchemaStoreImpl.generateUUID());
            if (stmt.executeUpdate() == 0) {
                throw SchemaExceptionCodes.LOCK_FAILED.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            if (1213 == e.getErrorCode() || 1062 == e.getErrorCode()) {
                throw SchemaExceptionCodes.ALREADY_LOCKED.create(e, schema.getSchema());
            }
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static void lockOldVersionTable(Connection con, Schema schema) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT locked FROM version FOR UPDATE");
            result = stmt.executeQuery();
            if (!result.next()) {
                throw SchemaExceptionCodes.MISSING_VERSION_ENTRY.create(schema.getSchema());
            }
            if (result.getBoolean(1)) {
                throw SchemaExceptionCodes.ALREADY_LOCKED.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            try {
                throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        try {
            stmt = con.prepareStatement("UPDATE version SET locked=?");
            stmt.setBoolean(1, true);
            if (stmt.executeUpdate() == 0) {
                throw SchemaExceptionCodes.LOCK_FAILED.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
    }

    @Override
    public void unlockSchema(Schema schema, int contextId, boolean background) throws OXException {
        int poolId = Database.resolvePool(contextId, true);
        CacheKey key = null;
        if (null != this.cache) {
            key = this.cache.newCacheKey(poolId, new Serializable[]{schema.getSchema()});
            try {
                this.cache.remove((Serializable)key);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        SchemaStoreImpl.unlockSchemaDB(schema, contextId, background);
        if (null != this.cache && null != key) {
            try {
                this.cache.remove((Serializable)key);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static void unlockSchemaDB(Schema schema, int contextId, boolean background) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            con.setAutoCommit(false);
            SchemaStoreImpl.deleteLock(con, schema, background ? BACKGROUND : LOCKED);
            if (Tools.tableExists(con, "version") && !background) {
                SchemaStoreImpl.unlockOldVersionTable(con, schema);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    private static void deleteLock(Connection con, Schema schema, String idiom) throws OXException {
        ExecutedTask[] tasks2 = SchemaStoreImpl.readUpdateTasks(con);
        boolean found = false;
        for (ExecutedTask task : tasks2) {
            if (!idiom.equals(task.getTaskName())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw SchemaExceptionCodes.UPDATE_CONFLICT.create(schema.getSchema());
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM updateTask WHERE cid=0 AND taskName=?");
            stmt.setString(1, idiom);
            if (stmt.executeUpdate() == 0) {
                throw SchemaExceptionCodes.UNLOCK_FAILED.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            if (1213 == e.getErrorCode() || 1062 == e.getErrorCode()) {
                throw SchemaExceptionCodes.UNLOCK_FAILED.create(e, schema.getSchema());
            }
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static void unlockOldVersionTable(Connection con, Schema schema) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT locked FROM version FOR UPDATE");
            result = stmt.executeQuery();
            if (!result.next()) {
                throw SchemaExceptionCodes.MISSING_VERSION_ENTRY.create(schema.getSchema());
            }
            if (!result.getBoolean(1)) {
                throw SchemaExceptionCodes.UPDATE_CONFLICT.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            try {
                throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        try {
            stmt = con.prepareStatement("UPDATE version SET version=?,locked=?");
            stmt.setInt(1, UpdateTaskCollection.getInstance().getHighestVersion());
            stmt.setBoolean(2, false);
            if (stmt.executeUpdate() == 0) {
                throw SchemaExceptionCodes.UNLOCK_FAILED.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
    }

    private static void loadOldVersionTable(Connection con, SchemaImpl schema) throws OXException {
        String sql = "SELECT version,locked,gw_compatible,admin_compatible,server FROM version FOR UPDATE";
        Statement stmt = null;
        ResultSet result = null;
        try {
            int pos;
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT version,locked,gw_compatible,admin_compatible,server FROM version FOR UPDATE");
            if (result.next()) {
                pos = 1;
                schema.setDBVersion(result.getInt(pos++));
                if (!schema.isLocked()) {
                    schema.setBlockingUpdatesRunning(result.getBoolean(pos++));
                }
            } else {
                throw SchemaExceptionCodes.MISSING_VERSION_ENTRY.create(schema.getSchema());
            }
            schema.setGroupwareCompatible(result.getBoolean(pos++));
            schema.setAdminCompatible(result.getBoolean(pos++));
            schema.setServer(result.getString(pos++));
            schema.setSchema(con.getCatalog());
            if (result.next()) {
                throw SchemaExceptionCodes.MULTIPLE_VERSION_ENTRY.create(schema.getSchema());
            }
        }
        catch (SQLException e) {
            try {
                throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    private static SchemaUpdateState loadSchemaStatus(Connection con) throws OXException, SQLException {
        SchemaUpdateStateImpl retval = new SchemaUpdateStateImpl();
        SchemaStoreImpl.loadUpdateTasks(con, retval);
        if (Tools.tableExists(con, "version")) {
            SchemaStoreImpl.loadOldVersionTable(con, retval);
        } else {
            retval.setDBVersion(200);
            retval.setBlockingUpdatesRunning(false);
            retval.setBackgroundUpdatesRunning(false);
            retval.setGroupwareCompatible(true);
            retval.setAdminCompatible(true);
            retval.setServer(Database.getServerName());
            retval.setSchema(con.getCatalog());
        }
        return retval;
    }

    private static void loadUpdateTasks(Connection con, SchemaUpdateStateImpl state) throws OXException {
        for (ExecutedTask task : SchemaStoreImpl.readUpdateTasks(con)) {
            if (LOCKED.equals(task.getTaskName())) {
                state.setBlockingUpdatesRunning(true);
                continue;
            }
            if (BACKGROUND.equals(task.getTaskName())) {
                state.setBackgroundUpdatesRunning(true);
                continue;
            }
            state.addExecutedTask(task.getTaskName());
        }
    }

    private static ExecutedTask[] readUpdateTasks(Connection con) throws OXException {
        String sql = "SELECT taskName,successful,lastModified FROM updateTask WHERE cid=0 FOR UPDATE";
        Statement stmt = null;
        ResultSet result = null;
        ArrayList<ExecutedTaskImpl> retval = new ArrayList<ExecutedTaskImpl>();
        try {
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT taskName,successful,lastModified FROM updateTask WHERE cid=0 FOR UPDATE");
            while (result.next()) {
                ExecutedTaskImpl task = new ExecutedTaskImpl(result.getString(1), result.getBoolean(2), new Date(result.getLong(3)));
                retval.add(task);
            }
        }
        catch (SQLException e) {
            try {
                throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Collections.sort(retval, (Comparator)new Comparator<ExecutedTask>(){

            @Override
            public int compare(ExecutedTask o1, ExecutedTask o2) {
                Date lastModified1 = o1.getLastModified();
                Date lastModified2 = o2.getLastModified();
                if (null == lastModified1) {
                    return null == lastModified2 ? 0 : -1;
                }
                if (null == lastModified2) {
                    return 1;
                }
                return lastModified1.compareTo(lastModified2);
            }
        });
        return retval.toArray(new ExecutedTask[retval.size()]);
    }

    @Override
    public void addExecutedTask(Connection con, String taskName, boolean success, int poolId, String schema) throws OXException {
        SchemaStoreImpl.addExecutedTask(con, taskName, success);
        if (null != this.cache) {
            CacheKey key = this.cache.newCacheKey(poolId, new Serializable[]{schema});
            try {
                this.cache.remove((Serializable)key);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static void addExecutedTask(Connection con, String taskName, boolean success) throws OXException {
        try {
            if (SchemaStoreImpl.hasUUID(con)) {
                SchemaStoreImpl.addExecutedTaskUUID(con, taskName, success);
            } else {
                SchemaStoreImpl.addExecutedTaskNoUUID(con, taskName, success);
            }
        }
        catch (SQLException e) {
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
    }

    private static void addExecutedTaskNoUUID(Connection con, String taskName, boolean success) throws OXException {
        boolean update = false;
        for (ExecutedTask executed : SchemaStoreImpl.readUpdateTasks(con)) {
            if (!taskName.equals(executed.getTaskName())) continue;
            update = true;
            break;
        }
        String insertSQL = "INSERT INTO updateTask (cid,successful,lastModified,taskName) VALUES (0,?,?,?)";
        String updateSQL = "UPDATE updateTask SET successful=?, lastModified=? WHERE cid=0 AND taskName=?";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(update ? "UPDATE updateTask SET successful=?, lastModified=? WHERE cid=0 AND taskName=?" : "INSERT INTO updateTask (cid,successful,lastModified,taskName) VALUES (0,?,?,?)");
            int pos = 1;
            stmt.setBoolean(pos++, success);
            stmt.setLong(pos++, System.currentTimeMillis());
            stmt.setString(pos++, taskName);
            int rows = stmt.executeUpdate();
            if (1 != rows) {
                throw SchemaExceptionCodes.WRONG_ROW_COUNT.create(Autoboxing.I((int)1), Autoboxing.I((int)rows));
            }
        }
        catch (SQLException e) {
            try {
                throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    private static void addExecutedTaskUUID(Connection con, String taskName, boolean success) throws OXException {
        boolean update = false;
        for (ExecutedTask executed : SchemaStoreImpl.readUpdateTasks(con)) {
            if (!taskName.equals(executed.getTaskName())) continue;
            update = true;
            break;
        }
        String insertSQL = "INSERT INTO updateTask (cid,successful,lastModified,taskName,uuid) VALUES (0,?,?,?,?)";
        String updateSQL = "UPDATE updateTask SET successful=?, lastModified=? WHERE cid=0 AND taskName=?";
        PreparedStatement stmt = null;
        try {
            int rows;
            stmt = con.prepareStatement(update ? "UPDATE updateTask SET successful=?, lastModified=? WHERE cid=0 AND taskName=?" : "INSERT INTO updateTask (cid,successful,lastModified,taskName,uuid) VALUES (0,?,?,?,?)");
            int pos = 1;
            stmt.setBoolean(pos++, success);
            stmt.setLong(pos++, System.currentTimeMillis());
            stmt.setString(pos++, taskName);
            if (!update) {
                stmt.setBytes(pos++, SchemaStoreImpl.generateUUID());
            }
            if (1 != (rows = stmt.executeUpdate())) {
                throw SchemaExceptionCodes.WRONG_ROW_COUNT.create(Autoboxing.I((int)1), Autoboxing.I((int)rows));
            }
        }
        catch (SQLException e) {
            try {
                throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    @Override
    public ExecutedTask[] getExecutedTasks(int poolId, String schemaName) throws OXException {
        ExecutedTask[] retval;
        Connection con = Database.get(poolId, schemaName);
        try {
            con.setAutoCommit(false);
            retval = SchemaStoreImpl.readUpdateTasks(con);
            con.commit();
        }
        catch (SQLException e) {
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(poolId, con);
        }
        return retval;
    }

    @Override
    public void setCacheService(CacheService cacheService) {
        try {
            this.cache = cacheService.getCache(CACHE_REGION);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public void removeCacheService() {
        if (null != this.cache) {
            try {
                this.cache.clear();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            this.cache = null;
        }
    }

    private static boolean hasUUID(Connection con) throws SQLException {
        return Tools.columnExists(con, TABLE_NAME, "uuid");
    }

    private static byte[] generateUUID() {
        UUID uuid = UUID.randomUUID();
        return UUIDs.toByteArray((UUID)uuid);
    }
}

