/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.mapping;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class ActualCosts
implements Mapper<BigDecimal> {
    public static final ActualCosts SINGLETON = new ActualCosts();

    protected ActualCosts() {
    }

    @Override
    public int getId() {
        return 302;
    }

    @Override
    public boolean isSet(Task task) {
        return task.containsActualCosts();
    }

    @Override
    public String getDBColumnName() {
        return "actual_costs";
    }

    @Override
    public String getDisplayName() {
        return "Current costs";
    }

    @Override
    public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
        if (null == task.getActualCosts()) {
            stmt.setNull(pos, 2);
        } else {
            stmt.setBigDecimal(pos, task.getActualCosts());
        }
    }

    @Override
    public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
        BigDecimal actualCosts = result.getBigDecimal(pos);
        if (!result.wasNull()) {
            task.setActualCosts(actualCosts);
        }
    }

    @Override
    public boolean equals(Task task1, Task task2) {
        if (task1.getActualCosts() == null) {
            return task2.getActualCosts() == null;
        }
        if (task2.getActualCosts() == null) {
            return task1.getActualCosts() == null;
        }
        return task1.getActualCosts().equals(task2.getActualCosts());
    }

    @Override
    public BigDecimal get(Task task) {
        return task.getActualCosts();
    }

    @Override
    public void set(Task task, BigDecimal value) {
        task.setActualCosts(value);
    }
}

