/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.PreRead;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskIterator;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.Collections;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.TIntObjectMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class TaskIterator2
implements TaskIterator,
Runnable {
    private final Context ctx;
    private final int userId;
    private final String sql;
    private final StatementSetter setter;
    private final int folderId;
    private final int[] taskAttributes;
    private final int[] additionalAttributes;
    private final StorageType type;
    private final Connection con;
    private final PreRead<Task> preread = new PreRead();
    private final Queue<Task> ready = new LinkedList<Task>();
    private OXException exc;
    private final Future<Object> runner;
    private final ParticipantStorage partStor = ParticipantStorage.getInstance();
    private final List<OXException> warnings = new ArrayList<OXException>(2);

    TaskIterator2(Context ctx, int userId, String sql, StatementSetter setter, int folderId, int[] attributes, StorageType type) {
        this(ctx, userId, sql, setter, folderId, attributes, type, null);
    }

    TaskIterator2(Context ctx, int userId, String sql, StatementSetter setter, int folderId, int[] attributes, StorageType type, Connection con) {
        this.ctx = ctx;
        this.userId = userId;
        this.sql = sql;
        this.setter = setter;
        this.folderId = folderId;
        ArrayList<Integer> tmp1 = new ArrayList<Integer>(attributes.length);
        ArrayList<Integer> tmp2 = new ArrayList<Integer>(attributes.length);
        for (int column : attributes) {
            if (null == Mapping.getMapping(column) && 20 != column) {
                tmp2.add(Autoboxing.I((int)column));
                continue;
            }
            tmp1.add(Autoboxing.I((int)column));
        }
        this.taskAttributes = Collections.toArray(tmp1);
        this.modifyAdditionalAttributes(tmp2);
        this.additionalAttributes = Collections.toArray(tmp2);
        this.type = type;
        this.con = con;
        ThreadPoolService threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
        this.runner = threadPool.submit(ThreadPools.trackableTask((Runnable)this));
    }

    private void modifyAdditionalAttributes(List<Integer> additional) {
        if (additional.contains(Autoboxing.I((int)221))) {
            if (!additional.contains(Autoboxing.I((int)220))) {
                additional.add(Autoboxing.I((int)220));
            }
            additional.remove(Autoboxing.I((int)221));
        }
    }

    public void close() throws OXException {
        try {
            this.runner.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw TaskExceptionCode.THREAD_ISSUE.create(e, new Object[0]);
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
    }

    public boolean hasNext() {
        return !this.ready.isEmpty() || this.preread.hasNext() || null != this.exc;
    }

    public boolean hasSize() {
        return false;
    }

    public Task next() throws OXException {
        if (this.ready.isEmpty() && !this.preread.hasNext()) {
            throw this.exc;
        }
        if (this.ready.isEmpty()) {
            try {
                ArrayList<Task> tasks2 = new ArrayList<Task>();
                tasks2.addAll(this.preread.take(this.additionalAttributes.length > 0));
                block11: for (int attribute : this.additionalAttributes) {
                    switch (attribute) {
                        case 105: {
                            this.addLastModifiedOfNewestAttachment(tasks2);
                            continue block11;
                        }
                        case 220: {
                            this.readParticipants(tasks2);
                            continue block11;
                        }
                        case 204: {
                            if (this.con == null) {
                                Reminder.loadReminder(this.ctx, this.userId, tasks2);
                                continue block11;
                            }
                            Reminder.loadReminder(this.ctx, this.userId, tasks2, this.con);
                            continue block11;
                        }
                        default: {
                            throw TaskExceptionCode.UNKNOWN_ATTRIBUTE.create(attribute);
                        }
                    }
                }
                this.ready.addAll(tasks2);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw TaskExceptionCode.THREAD_ISSUE.create(e, new Object[0]);
            }
        }
        return this.ready.poll();
    }

    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    private void readParticipants(List<Task> tasks2) throws OXException {
        int[] ids = new int[tasks2.size()];
        for (int i = 0; i < tasks2.size(); ++i) {
            ids[i] = tasks2.get(i).getObjectID();
        }
        Map<Integer, Set<TaskParticipant>> parts = null;
        parts = this.con == null ? this.partStor.selectParticipants(this.ctx, ids, this.type) : this.partStor.selectParticipants(this.ctx, ids, this.type, this.con);
        for (Task task : tasks2) {
            Set<TaskParticipant> participants = parts.get(Autoboxing.I((int)task.getObjectID()));
            if (null == participants) continue;
            task.setParticipants(TaskLogic.createParticipants(participants));
            task.setUsers(TaskLogic.createUserParticipants(participants));
        }
    }

    private void addLastModifiedOfNewestAttachment(List<Task> tasks2) throws OXException {
        int[] ids = new int[tasks2.size()];
        for (int i = 0; i < tasks2.size(); ++i) {
            ids[i] = tasks2.get(i).getObjectID();
        }
        AttachmentBase attachmentBase = Attachments.getInstance();
        TIntObjectMap<Date> dates = attachmentBase.getNewestCreationDates(this.ctx, 4, ids);
        for (Task task : tasks2) {
            Date newestCreationDate = (Date)dates.get(task.getObjectID());
            if (null == newestCreationDate) continue;
            task.setLastModifiedOfNewestAttachment(newestCreationDate);
        }
    }

    public int size() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        Connection myCon;
        if (null == this.con) {
            try {
                myCon = DBPool.pickup(this.ctx);
            }
            catch (OXException e) {
                this.preread.finished();
                this.exc = TaskExceptionCode.NO_CONNECTION.create(e, new Object[0]);
                return;
            }
        } else {
            myCon = this.con;
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = myCon.prepareStatement(this.sql);
            this.setter.perform(stmt);
            result = stmt.executeQuery();
            while (result.next()) {
                Task task = new Task();
                int pos = 1;
                for (int taskField : this.taskAttributes) {
                    Mapper<?> mapper = Mapping.getMapping(taskField);
                    if (20 == taskField) {
                        if (-1 == this.folderId) {
                            task.setParentFolderID(result.getInt(pos++));
                            continue;
                        }
                        task.setParentFolderID(this.folderId);
                        continue;
                    }
                    if (null == mapper) continue;
                    mapper.fromDB(result, pos++, task);
                }
                this.preread.offer(task);
            }
            this.preread.finished();
        }
        catch (SQLException e) {
            this.exc = TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            this.preread.finished();
            DBUtils.closeSQLStuff(result, stmt);
            if (null == this.con) {
                DBPool.closeReaderSilent(this.ctx, myCon);
            }
        }
        catch (Throwable t) {
            this.exc = TaskExceptionCode.THREAD_ISSUE.create(t, new Object[0]);
            this.preread.finished();
            {
                catch (Throwable throwable) {
                    this.preread.finished();
                    DBUtils.closeSQLStuff(result, stmt);
                    if (null == this.con) {
                        DBPool.closeReaderSilent(this.ctx, myCon);
                    }
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            if (null == this.con) {
                DBPool.closeReaderSilent(this.ctx, myCon);
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        if (null == this.con) {
            DBPool.closeReaderSilent(this.ctx, myCon);
        }
    }

    static interface StatementSetter {
        public void perform(PreparedStatement var1) throws SQLException;
    }
}

