/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.GetTask;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public final class DeleteData {
    private static final FolderStorage foldStor = FolderStorage.getInstance();
    private final Context ctx;
    private final User user;
    private final UserPermissionBits permissionBits;
    private final FolderObject folder;
    private final int taskId;
    private final Date lastModified;
    private Task task;

    public DeleteData(Context ctx, User user, UserPermissionBits permissionBits, FolderObject folder, int taskId, Date lastModified) {
        this.ctx = ctx;
        this.user = user;
        this.permissionBits = permissionBits;
        this.folder = folder;
        this.taskId = taskId;
        this.lastModified = lastModified;
    }

    private int getFolderId() {
        return this.folder.getObjectID();
    }

    private Task getOrigTask() throws OXException {
        if (null == this.task) {
            this.task = GetTask.load(this.ctx, this.getFolderId(), this.taskId, StorageType.ACTIVE);
        }
        return this.task;
    }

    public void prepare() throws OXException {
        foldStor.selectFolderById(this.ctx, this.taskId, this.getFolderId(), StorageType.ACTIVE);
        if (this.getOrigTask().getLastModified().after(this.lastModified)) {
            throw TaskExceptionCode.MODIFIED.create();
        }
        Permission.checkDelete(this.ctx, this.user, this.permissionBits, this.folder, this.task);
    }

    public void doDelete() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            DBUtils.startTransaction(con);
            IDGenerator.getId(this.ctx, 4, con);
            TaskLogic.deleteTask(this.ctx, con, this.user.getId(), TaskLogic.clone(this.getOrigTask()), this.lastModified);
            this.deleteReminder(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw TaskExceptionCode.DELETE_FAILED.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    public void sentEvent(Session session) throws OXException {
        new EventClient(session).delete(this.getOrigTask());
    }

    private void deleteReminder(Connection con) throws OXException {
        Reminder.deleteReminder(this.ctx, con, this.task);
    }
}

