/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail.folder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.AbstractWarningAwareReadOnlyValue;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inbox
implements PreferencesItemService {
    private static final Logger LOG = LoggerFactory.getLogger(Inbox.class);

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "defaultFolder", "inbox"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new AbstractWarningAwareReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                block13: {
                    MailServletInterface mail = null;
                    try {
                        mail = MailServletInterface.getInstance(session);
                        setting.setSingleValue(mail.getInboxFolder(0));
                        this.addWarnings(mail.getWarnings());
                    }
                    catch (OXException e) {
                        if (e.isPrefix("ACC") && MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.getNumber() == e.getCode()) {
                            setting.setSingleValue(null);
                            break block13;
                        }
                        throw e;
                    }
                    finally {
                        if (mail != null) {
                            try {
                                mail.close(true);
                            }
                            catch (OXException e) {
                                LOG.error("", (Throwable)e);
                            }
                        }
                    }
                }
            }
        };
    }
}

