/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Separators
implements PreferencesItemService {
    final boolean primaryOnly;
    static final String PROTOCOL_UNIFIED_INBOX = UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX;

    public Separators() {
        this.primaryOnly = true;
    }

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "separators"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                try {
                    JSONObject retval = new JSONObject(4);
                    if (Separators.this.primaryOnly || !userConfig.isMultipleMailAccounts()) {
                        Character sep = this.getSeparator(0, session);
                        if (null != sep) {
                            retval.put(Integer.toString(0), (Object)sep.toString());
                        }
                    } else {
                        MailAccountStorageService mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
                        if (null == mass) {
                            Character sep = this.getSeparator(0, session);
                            if (null != sep) {
                                retval.put(Integer.toString(0), (Object)sep.toString());
                            }
                        } else {
                            List<MailAccount> accounts = Arrays.asList(mass.getUserMailAccounts(user.getId(), ctx.getContextId()));
                            for (MailAccount mailAccount : accounts) {
                                Character sep;
                                if (PROTOCOL_UNIFIED_INBOX.equals(mailAccount.getMailProtocol()) || null == (sep = this.getSeparator(mailAccount.getId(), session))) continue;
                                retval.put(Integer.toString(mailAccount.getId()), (Object)sep.toString());
                            }
                        }
                    }
                    if (retval.isEmpty()) {
                        setting.setSingleValue("null");
                    } else {
                        setting.setSingleValue(retval.toString());
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Character getSeparator(int accountId, Session session) throws OXException {
                MailSessionCache sessionCache = MailSessionCache.getInstance(session);
                Character sep = (Character)sessionCache.getParameter(accountId, MailSessionParameterNames.getParamSeparator());
                if (null == sep) {
                    MailAccess<IMailFolderStorage, IMailMessageStorage> ma = null;
                    try {
                        ma = MailAccess.getInstance(session, accountId);
                        ma.connect(false);
                        sep = Character.valueOf(ma.getFolderStorage().getFolder("INBOX").getSeparator());
                        sessionCache.putParameter(accountId, MailSessionParameterNames.getParamSeparator(), sep);
                    }
                    catch (Exception x) {
                        Logger logger = LoggerFactory.getLogger(Separators.class);
                        logger.debug("Failed determining separator character for mail account {} of user {} in context {}", new Object[]{accountId, session.getUserId(), session.getContextId(), x});
                    }
                    finally {
                        if (null != ma) {
                            ma.close(true);
                        }
                    }
                }
                return sep;
            }
        };
    }
}

