/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.AbstractUserFuncs;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.session.Session;
import java.util.Set;

public final class SpellCheck
implements PreferencesItemService {
    private static final String NAME = "spellcheck";

    @Override
    public String[] getPath() {
        return new String[]{NAME};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new AbstractUserFuncs(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                Set<String> set = user.getAttributes().get(SpellCheck.NAME);
                if (null != set && !set.isEmpty()) {
                    setting.setSingleValue(Boolean.valueOf(set.iterator().next()));
                } else {
                    setting.setSingleValue(Boolean.FALSE);
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                String value = setting.getSingleValue().toString();
                UserStorage.getInstance().setAttribute(SpellCheck.NAME, value, user.getId(), ctx);
            }
        };
    }
}

