/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search.impl;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.sql.SearchStrings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineImpl
extends DBService
implements InfostoreSearchEngine {
    static final Logger LOG = LoggerFactory.getLogger(SearchEngineImpl.class);
    private final InfostoreSecurityImpl security = new InfostoreSecurityImpl();
    private static final String[] SEARCH_FIELDS = new String[]{"infostore_document.title", "infostore_document.url", "infostore_document.description", "infostore_document.categories", "infostore_document.filename", "infostore_document.file_version_comment"};

    public SearchEngineImpl() {
        super(null);
    }

    public SearchEngineImpl(DBProvider provider) {
        super(provider);
        this.security.setProvider(provider);
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        if (this.security != null) {
            this.security.setProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchIterator<DocumentMetadata> search(String query, Metadata[] cols, int folderId, Metadata sortedBy, int dir, int start, int end, Context ctx, User user, UserPermissionBits userPermissions) throws OXException {
        int maxResults;
        List<Integer> all = new ArrayList<Integer>();
        List<Integer> own = new ArrayList<Integer>();
        boolean addQuery = false;
        Connection con = this.getReadConnection(ctx);
        try {
            EffectivePermission perm;
            int userId = user.getId();
            if (folderId == -11 || folderId == -10) {
                Queue<FolderObject> queue = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(userId, user.getGroups(), userPermissions.getAccessibleModules(), 8, ctx, con)).asQueue();
                for (FolderObject folder : queue) {
                    EffectivePermission perm2 = folder.getEffectiveUserPermission(userId, userPermissions);
                    if (perm2.canReadAllObjects()) {
                        all.add(folder.getObjectID());
                        continue;
                    }
                    if (!perm2.canReadOwnObjects()) continue;
                    own.add(folder.getObjectID());
                }
            } else {
                perm = this.security.getFolderPermission(folderId, ctx, user, userPermissions, con);
                if (perm.canReadAllObjects()) {
                    all.add(folderId);
                } else if (perm.canReadOwnObjects()) {
                    own.add(folderId);
                } else {
                    SearchIterator i$ = SearchIteratorAdapter.emptyIterator();
                    return i$;
                }
            }
            if (all.isEmpty() && own.isEmpty()) {
                perm = SearchIteratorAdapter.emptyIterator();
                return perm;
            }
            all = Collections.unmodifiableList(all);
            own = Collections.unmodifiableList(own);
        }
        finally {
            this.releaseReadConnection(ctx, con);
            con = null;
        }
        if ((Strings.isEmpty((String)query) || "*".equals(query)) && -11 != (maxResults = -11 != start && -11 != end && end >= start ? end + 1 - start : (-11 != start ? 200 : (-11 != end ? end + 1 : -11))) && own.size() + all.size() > maxResults && (null == sortedBy || InfostoreQueryCatalog.Table.INFOSTORE.getFieldSet().contains(sortedBy))) {
            return this.get(ctx, user, all, own, cols, sortedBy, dir, start, end);
        }
        StringAllocator SQL_QUERY = new StringAllocator(512);
        SQL_QUERY.append(this.getResultFieldsSelect(cols));
        SQL_QUERY.append(" FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = ").append(ctx.getContextId());
        this.appendFolders(SQL_QUERY, user.getId(), all, own);
        String q = query;
        if (q.length() > 0 && !"*".equals(q)) {
            SearchEngineImpl.checkPatternLength(q);
            boolean containsWildcard = q.indexOf(42) >= 0 || 0 <= q.indexOf(63);
            addQuery = true;
            q = q.replaceAll("\\\\", "\\\\\\\\");
            q = q.replaceAll("%", "\\\\%");
            q = q.replace('*', '%');
            q = q.replace('?', '_');
            q = q.replaceAll("'", "\\\\'");
            if (!containsWildcard) {
                q = "%" + q + "%";
            }
            StringBuffer SQL_QUERY_OBJECTS = new StringBuffer();
            for (String currentField : SEARCH_FIELDS) {
                if (SQL_QUERY_OBJECTS.length() > 0) {
                    SQL_QUERY_OBJECTS.append(" OR ");
                }
                SQL_QUERY_OBJECTS.append(currentField);
                SQL_QUERY_OBJECTS.append(" LIKE (?)");
            }
            if (SQL_QUERY_OBJECTS.length() > 0) {
                SQL_QUERY.append(" AND (");
                SQL_QUERY.append(SQL_QUERY_OBJECTS);
                SQL_QUERY.append(") ");
            }
        }
        this.appendOrderBy(SQL_QUERY, sortedBy, dir);
        this.appendLimit(SQL_QUERY, start, end);
        Connection con2 = this.getReadConnection(ctx);
        boolean keepConnection = false;
        PreparedStatement stmt = null;
        try {
            stmt = con2.prepareStatement(SQL_QUERY.toString());
            if (addQuery) {
                for (int i = 0; i < SEARCH_FIELDS.length; ++i) {
                    stmt.setString(i + 1, q);
                }
            }
            InfostoreSearchIterator iter = new InfostoreSearchIterator(stmt.executeQuery(), this, cols, ctx, con2, stmt);
            keepConnection = true;
            InfostoreSearchIterator infostoreSearchIterator = iter;
            return infostoreSearchIterator;
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, SQL_QUERY.toString());
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e, new Object[0]);
        }
        finally {
            if (con2 != null && !keepConnection) {
                this.releaseReadConnection(ctx, con2);
            }
        }
    }

    private void appendFolders(StringAllocator sqlQuery, int userID, List<Integer> readAllFolders, List<Integer> readOwnFolders) {
        boolean needOr = false;
        if (!readAllFolders.isEmpty()) {
            sqlQuery.append(" AND ((infostore.folder_id IN (").append(this.join(readAllFolders)).append("))");
            needOr = true;
        }
        if (!readOwnFolders.isEmpty()) {
            if (needOr) {
                sqlQuery.append(" OR ");
            } else {
                sqlQuery.append(" AND (");
            }
            sqlQuery.append("(infostore.created_by = ").append(userID).append(" AND infostore.folder_id in (").append(this.join(readOwnFolders)).append(")))");
        } else {
            sqlQuery.append(')');
        }
    }

    private void appendLimit(StringAllocator sqlQuery, int start, int end) {
        if (start != -11 && end != -11) {
            if (end >= start) {
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(start);
                sqlQuery.append(", ");
                sqlQuery.append(end + 1 - start);
            }
        } else {
            if (start != -11) {
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(start);
                sqlQuery.append(",200");
            }
            if (end != -11) {
                sqlQuery.append(" LIMIT ");
                sqlQuery.append(end + 1);
            }
        }
    }

    private void appendOrderBy(StringAllocator sqlQuery, Metadata sortedBy, int dir) {
        String[] orderColumn;
        if (sortedBy != null && dir != -11 && (orderColumn = this.switchMetadata2DBColumns(new Metadata[]{sortedBy})) != null && orderColumn[0] != null) {
            if (dir == -1) {
                sqlQuery.append(" ORDER BY ");
                sqlQuery.append(orderColumn[0]);
                sqlQuery.append(" DESC");
            } else if (dir == 1) {
                sqlQuery.append(" ORDER BY ");
                sqlQuery.append(orderColumn[0]);
                sqlQuery.append(" ASC");
            }
        }
    }

    private SearchIterator<DocumentMetadata> get(Context context, User user, List<Integer> readAllFolders, List<Integer> readOwnFolders, Metadata[] cols, Metadata sortedBy, int dir, int start, int end) throws OXException {
        StringAllocator sqlQuery = new StringAllocator();
        sqlQuery.append("SELECT infostore.id FROM infostore WHERE infostore.cid=").append(context.getContextId());
        this.appendFolders(sqlQuery, user.getId(), readAllFolders, readOwnFolders);
        this.appendOrderBy(sqlQuery, sortedBy, dir);
        this.appendLimit(sqlQuery, start, end);
        Connection connection = this.getReadConnection(context);
        ArrayList<Integer> objectIDs = new ArrayList<Integer>();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            statement = connection.prepareStatement(sqlQuery.toString());
            results = statement.executeQuery();
            while (results.next()) {
                objectIDs.add(results.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                LOG.error("", (Throwable)e);
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, sqlQuery.toString());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(results, statement);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(results, statement);
        if (0 == objectIDs.size()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        sqlQuery = new StringAllocator();
        sqlQuery.append(this.getResultFieldsSelect(cols));
        sqlQuery.append(" FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = ").append(context.getContextId()).append(" AND infostore.id IN (").append(this.join(objectIDs)).append(")");
        this.appendOrderBy(sqlQuery, sortedBy, dir);
        boolean keepConnection = false;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(sqlQuery.toString());
            InfostoreSearchIterator iter = new InfostoreSearchIterator(stmt.executeQuery(), this, cols, context, connection, stmt);
            keepConnection = true;
            InfostoreSearchIterator infostoreSearchIterator = iter;
            return infostoreSearchIterator;
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, sqlQuery.toString());
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e, new Object[0]);
        }
        finally {
            if (connection != null && !keepConnection) {
                this.releaseReadConnection(context, connection);
            }
        }
    }

    public static void checkPatternLength(String pattern) throws OXException {
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters) {
            return;
        }
        if (null != pattern && SearchStrings.lengthWithoutWildcards(pattern) < minimumSearchCharacters) {
            throw InfostoreExceptionCodes.PATTERN_NEEDS_MORE_CHARACTERS.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    private String join(List<Integer> all) {
        StringBuffer joined = new StringBuffer();
        for (Integer i : all) {
            joined.append(i.toString());
            joined.append(',');
        }
        joined.setLength(joined.length() - 1);
        return joined.toString();
    }

    @Override
    public void index(DocumentMetadata document, Context ctx, User user, UserPermissionBits userPermissions) {
    }

    @Override
    public void unIndex0r(int id, Context ctx, User user, UserPermissionBits userPermissions) {
    }

    private String[] switchMetadata2DBColumns(Metadata[] columns) {
        ArrayList<String> retval = new ArrayList<String>();
        block23: for (Metadata current : columns) {
            switch (current.getId()) {
                default: {
                    continue block23;
                }
                case 5: {
                    retval.add("infostore.last_modified");
                    continue block23;
                }
                case 6: {
                    retval.add("infostore.last_modified");
                    continue block23;
                }
                case 4: {
                    retval.add("infostore.creating_date");
                    continue block23;
                }
                case 3: {
                    retval.add("infostore.changed_by");
                    continue block23;
                }
                case 20: {
                    retval.add("infostore.folder_id");
                    continue block23;
                }
                case 700: {
                    retval.add("infostore_document.title");
                    continue block23;
                }
                case 705: {
                    retval.add("infostore.version");
                    continue block23;
                }
                case 750: {
                    retval.add("infostore_document.description");
                    continue block23;
                }
                case 702: {
                    retval.add("infostore_document.filename");
                    continue block23;
                }
                case 751: {
                    retval.add("infostore.id");
                    continue block23;
                }
                case 1: {
                    retval.add("infostore.id");
                    continue block23;
                }
                case 704: {
                    retval.add("infostore_document.file_size");
                    continue block23;
                }
                case 703: {
                    retval.add("infostore_document.file_mimetype");
                    continue block23;
                }
                case 706: {
                    retval.add("infostore_document.description");
                    continue block23;
                }
                case 707: {
                    retval.add("infostore.locked_until");
                    continue block23;
                }
                case 701: {
                    retval.add("infostore_document.url");
                    continue block23;
                }
                case 2: {
                    retval.add("infostore.created_by");
                    continue block23;
                }
                case 100: {
                    retval.add("infostore_document.categories");
                    continue block23;
                }
                case 708: {
                    retval.add("infostore_document.file_md5sum");
                    continue block23;
                }
                case 709: {
                    retval.add("infostore_document.file_version_comment");
                    continue block23;
                }
                case 102: {
                    retval.add("infostore.color_label");
                }
            }
        }
        return retval.toArray(new String[0]);
    }

    private String getResultFieldsSelect(Metadata[] RESULT_FIELDS) {
        String[] DB_RESULT_FIELDS = this.switchMetadata2DBColumns(RESULT_FIELDS);
        StringBuilder selectFields = new StringBuilder();
        boolean id = false;
        for (String currentField : DB_RESULT_FIELDS) {
            if (currentField.equals("infostore.id")) {
                currentField = "infostore.id";
                id = true;
            }
            selectFields.append(currentField);
            selectFields.append(", ");
        }
        if (!id) {
            selectFields.append("infostore.id,");
        }
        String retval = "";
        if (selectFields.length() > 0) {
            retval = "SELECT DISTINCT " + selectFields.toString();
            retval = retval.substring(0, retval.lastIndexOf(", "));
        }
        return retval;
    }

    public static class InfostoreSearchIterator
    implements SearchIterator<DocumentMetadata> {
        private Statement stmt;
        private Connection readCon;
        private ResultSet rs;
        private DocumentMetadata next;
        private final Metadata[] columns;
        private final SearchEngineImpl s;
        private final Context ctx;
        private final List<OXException> warnings = new ArrayList<OXException>(2);
        private final SearchIterator<DocumentMetadata> delegate;

        public InfostoreSearchIterator(ResultSet rs, SearchEngineImpl s, Metadata[] columns, Context ctx, Connection readCon, Statement stmt) throws OXException {
            this.rs = rs;
            this.s = s;
            this.columns = columns;
            this.ctx = ctx;
            this.readCon = readCon;
            this.stmt = stmt;
            SearchIteratorAdapter delegate = null;
            try {
                if (rs.next()) {
                    LinkedList<DocumentMetadataImpl> list = new LinkedList<DocumentMetadataImpl>();
                    boolean goahead = true;
                    DocumentMetadataImpl current = null;
                    while (goahead) {
                        current = this.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                        while (current == null && rs.next()) {
                            current = this.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                        }
                        if (current == null) {
                            goahead = false;
                        } else {
                            list.add(current);
                            current = null;
                            goahead = rs.next();
                        }
                        if (goahead) continue;
                        this.close();
                    }
                    delegate = new SearchIteratorAdapter(list.iterator(), list.size());
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.INFOSTORE});
            }
            this.delegate = delegate;
        }

        public boolean hasNext() throws OXException {
            return null == this.delegate ? this.next != null : this.delegate.hasNext();
        }

        public DocumentMetadata next() throws OXException, OXException {
            if (null != this.delegate) {
                return (DocumentMetadata)this.delegate.next();
            }
            try {
                DocumentMetadata retval = null;
                retval = this.next;
                if (this.rs.next()) {
                    this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    while (this.next == null && this.rs.next()) {
                        this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    }
                    if (this.next == null) {
                        this.close();
                    }
                } else {
                    this.close();
                }
                return retval;
            }
            catch (Exception exc) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)exc, new Object[]{EnumComponent.INFOSTORE});
            }
        }

        public void close() throws OXException {
            this.next = null;
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.rs = null;
            }
            catch (SQLException e) {
                LOG.debug("", (Throwable)e);
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.stmt = null;
            }
            catch (SQLException e) {
                LOG.debug("", (Throwable)e);
            }
            if (null != this.readCon) {
                this.s.releaseReadConnection(this.ctx, this.readCon);
                this.readCon = null;
            }
        }

        public int size() {
            if (null != this.delegate) {
                return this.delegate.size();
            }
            return -1;
        }

        public boolean hasSize() {
            return false;
        }

        public void addWarning(OXException warning) {
            if (null == this.delegate) {
                this.warnings.add(warning);
            } else {
                this.delegate.addWarning(warning);
            }
        }

        public OXException[] getWarnings() {
            if (null != this.delegate) {
                return this.delegate.getWarnings();
            }
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            if (null != this.delegate) {
                return this.delegate.hasWarnings();
            }
            return !this.warnings.isEmpty();
        }

        private DocumentMetadataImpl fillDocumentMetadata(DocumentMetadataImpl retval, Metadata[] columns, ResultSet result) throws SQLException {
            block23: for (int i = 0; i < columns.length; ++i) {
                switch (columns[i].getId()) {
                    default: {
                        continue block23;
                    }
                    case 5: {
                        retval.setLastModified(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 6: {
                        retval.setLastModified(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 4: {
                        retval.setCreationDate(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 3: {
                        retval.setModifiedBy(result.getInt(i + 1));
                        continue block23;
                    }
                    case 20: {
                        retval.setFolderId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 700: {
                        retval.setTitle(result.getString(i + 1));
                        continue block23;
                    }
                    case 705: {
                        retval.setVersion(result.getInt(i + 1));
                        continue block23;
                    }
                    case 750: {
                        retval.setDescription(result.getString(i + 1));
                        continue block23;
                    }
                    case 702: {
                        retval.setFileName(result.getString(i + 1));
                        continue block23;
                    }
                    case 751: {
                        retval.setId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 1: {
                        retval.setId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 704: {
                        retval.setFileSize(result.getLong(i + 1));
                        continue block23;
                    }
                    case 703: {
                        retval.setFileMIMEType(result.getString(i + 1));
                        continue block23;
                    }
                    case 706: {
                        retval.setDescription(result.getString(i + 1));
                        continue block23;
                    }
                    case 707: {
                        retval.setLockedUntil(new Date(result.getLong(i + 1)));
                        if (!result.wasNull()) continue block23;
                        retval.setLockedUntil(null);
                        continue block23;
                    }
                    case 701: {
                        retval.setURL(result.getString(i + 1));
                        continue block23;
                    }
                    case 2: {
                        retval.setCreatedBy(result.getInt(i + 1));
                        continue block23;
                    }
                    case 100: {
                        retval.setCategories(result.getString(i + 1));
                        continue block23;
                    }
                    case 708: {
                        retval.setFileMD5Sum(result.getString(i + 1));
                        continue block23;
                    }
                    case 709: {
                        retval.setVersionComment(result.getString(i + 1));
                        continue block23;
                    }
                    case 102: {
                        retval.setColorLabel(result.getInt(i + 1));
                    }
                }
            }
            retval.setIsCurrentVersion(true);
            return retval;
        }
    }
}

