/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.paths.impl;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.Resolved;
import com.openexchange.groupware.infostore.WebdavFolderAliases;
import com.openexchange.groupware.infostore.paths.impl.AbstractPathResolver;
import com.openexchange.groupware.infostore.paths.impl.ResolvedImpl;
import com.openexchange.groupware.infostore.webdav.URLCache;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.webdav.protocol.WebdavPath;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathResolverImpl
extends AbstractPathResolver
implements URLCache {
    private Mode MODE;
    private static final Logger LOG = LoggerFactory.getLogger(PathResolverImpl.class);
    private final ThreadLocal<Map<WebdavPath, Resolved>> resolveCache = new ThreadLocal();
    private final ThreadLocal<TIntObjectMap<WebdavPath>> docPathCache = new ThreadLocal();
    private final ThreadLocal<TIntObjectMap<WebdavPath>> folderPathCache = new ThreadLocal();
    private final InfostoreFacade database;
    private WebdavFolderAliases aliases;

    public PathResolverImpl(DBProvider provider, InfostoreFacade database) {
        this.setProvider(provider);
        this.database = database;
    }

    public PathResolverImpl(InfostoreFacade database) {
        this.database = database;
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        this.MODE = new CACHE_MODE(provider);
    }

    @Override
    public WebdavPath getPathForDocument(int relativeToFolder, int documentId, ServerSession session) throws OXException {
        TIntObjectMap<WebdavPath> cache = this.docPathCache.get();
        Map<WebdavPath, Resolved> resCache = this.resolveCache.get();
        if (cache.containsKey(documentId)) {
            return this.relative(relativeToFolder, (WebdavPath)cache.get(documentId), session);
        }
        DocumentMetadata dm = this.database.getDocumentMetadata(documentId, -1, session);
        if (dm.getFileName() == null || dm.getFileName().equals("")) {
            throw InfostoreExceptionCodes.DOCUMENT_CONTAINS_NO_FILE.create(documentId);
        }
        WebdavPath path = this.getPathForFolder(0, (int)dm.getFolderId(), session).dup().append(dm.getFileName());
        cache.put(documentId, (Object)path);
        resCache.put(path, new ResolvedImpl(path, documentId, true));
        return this.relative(relativeToFolder, path, session);
    }

    @Override
    public WebdavPath getPathForFolder(int relativeToFolder, int folderId, ServerSession session) throws OXException {
        if (folderId == 9) {
            return new WebdavPath(new String[0]);
        }
        if (folderId == relativeToFolder) {
            return new WebdavPath(new String[0]);
        }
        Map<WebdavPath, Resolved> resCache = this.resolveCache.get();
        TIntObjectMap<WebdavPath> cache = this.folderPathCache.get();
        if (cache.containsKey(folderId)) {
            return this.relative(relativeToFolder, (WebdavPath)cache.get(folderId), session);
        }
        ArrayList<FolderObject> path = new ArrayList<FolderObject>();
        FolderObject folder = this.getFolder(folderId, session.getContext());
        path.add(folder);
        while (folder != null) {
            if (folder.getParentFolderID() == 0) {
                folder = null;
                continue;
            }
            folder = this.getFolder(folder.getParentFolderID(), session.getContext());
            path.add(folder);
        }
        int length = path.size();
        WebdavPath thePath = new WebdavPath(new String[0]);
        for (int i = length - 1; i > -1; --i) {
            String alias;
            folder = (FolderObject)path.get(i);
            String folderName = folder.getFolderName();
            if (this.aliases != null && (alias = this.aliases.getAlias(folder.getObjectID())) != null) {
                folderName = alias;
            }
            thePath.append(folderName);
            WebdavPath current = thePath.dup();
            cache.put(Integer.valueOf(folder.getObjectID()).intValue(), (Object)current);
            resCache.put(current, new ResolvedImpl(current, folder.getObjectID(), false));
        }
        return this.relative(relativeToFolder, thePath, session);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Resolved resolve(int relativeToFolder, WebdavPath path, ServerSession session) throws OXException {
        block15: {
            cache = this.resolveCache.get();
            if (cache.containsKey(absolutePath = this.absolute(relativeToFolder, path, session))) {
                return cache.get(absolutePath);
            }
            con = null;
            stmt = null;
            rs = null;
            relpath = this.getPathForFolder(0, relativeToFolder, session);
            resolved = new ResolvedImpl(relpath, relativeToFolder, false);
            cache.put(resolved.getPath(), resolved);
            current = new WebdavPath(new String[0]);
            try {
                parentId = relativeToFolder;
                compCount = 0;
lbl15:
                // 3 sources

                for (String component : path) {
                    last = ++compCount == path.size();
                    current.append(new String[]{component});
                    this.tryAlias(component, parentId, current, cache);
                    resolved = cache.get(current);
                    if (resolved != null) {
                        parentId = resolved.getId();
                    }
                    if (resolved != null) continue;
                    if (con == null) {
                        con = this.getReadConnection(session.getContext());
                    }
                    stmt = con.prepareStatement("SELECT folder.fuid, folder.fname FROM oxfolder_tree AS folder JOIN oxfolder_tree AS parent ON (folder.parent = parent.fuid AND folder.cid = parent.cid) WHERE folder.cid = ? and parent.fuid = ? and folder.fname = ?");
                    stmt.setInt(1, session.getContextId());
                    stmt.setInt(2, parentId);
                    stmt.setString(3, component);
                    rs = stmt.executeQuery();
                    found = false;
                    folderid = 0;
                    while (rs.next()) {
                        fname = rs.getString(2);
                        if (!fname.equals(component)) continue;
                        if (found) {
                            e = InfostoreExceptionCodes.DUPLICATE_SUBFOLDER.create(new Object[]{Autoboxing.I((int)parentId), component, Autoboxing.I((int)session.getContextId())});
                            PathResolverImpl.LOG.warn(e.toString(), (Throwable)e);
                        }
                        folderid = rs.getInt(1);
                        found = true;
                    }
                    stmt.close();
                    if (found) ** GOTO lbl83
                    if (last) {
                        stmt.close();
                        stmt = con.prepareStatement("SELECT info.id, doc.filename FROM infostore AS info JOIN infostore_document AS doc ON (info.cid = doc.cid AND info.id = doc.infostore_id AND doc.version_number = info.version) WHERE info.cid = ? AND info.folder_id = ? AND doc.filename = ?");
                        stmt.setInt(1, session.getContextId());
                        stmt.setInt(2, parentId);
                        stmt.setString(3, component);
                        rs = stmt.executeQuery();
                        found = false;
                        id = 0;
                        while (rs.next()) {
                            name = rs.getString(2);
                            if (!name.equals(component)) continue;
                            if (found) {
                                e = InfostoreExceptionCodes.DUPLICATE_SUBFOLDER.create(new Object[]{Autoboxing.I((int)parentId), component, Autoboxing.I((int)session.getContextId())});
                                PathResolverImpl.LOG.warn(e.toString(), (Throwable)e);
                            }
                            found = true;
                            id = rs.getInt(1);
                        }
                        if (found) {
                            resolved = new ResolvedImpl(current, id, true);
                            cache.put(resolved.getPath(), resolved);
                            name = resolved;
                            break block15;
                        }
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl90
            }
            catch (SQLException x) {
                try {
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(x, new Object[]{stmt.toString()});
                }
                catch (Throwable var22_25) {
                    this.close((PreparedStatement)stmt, rs);
                    this.releaseReadConnection(session.getContext(), con);
                    throw var22_25;
                }
            }
        }
        this.close((PreparedStatement)stmt, rs);
        this.releaseReadConnection(session.getContext(), con);
        return name;
lbl-1000:
        // 1 sources

        {
            throw OXException.notFound((String)"");
lbl83:
            // 1 sources

            nextStep = folderid;
            rs.close();
            parentId = nextStep;
            res = new ResolvedImpl(current, parentId, false);
            cache.put(res.getPath(), res);
            ** GOTO lbl15
lbl90:
            // 1 sources

            var14_15 = new ResolvedImpl(current, parentId, false);
        }
        this.close((PreparedStatement)stmt, rs);
        this.releaseReadConnection(session.getContext(), con);
        return var14_15;
    }

    private void tryAlias(String component, int parentId, WebdavPath current, Map<WebdavPath, Resolved> cache) {
        if (this.aliases == null) {
            return;
        }
        int aliasId = this.aliases.getId(component, parentId);
        if (-1 == aliasId) {
            return;
        }
        ResolvedImpl res = new ResolvedImpl(current, aliasId, false);
        cache.put(res.getPath(), res);
    }

    @Override
    public void invalidate(WebdavPath url, int id, URLCache.Type type) {
        this.resolveCache.get().remove(url);
        switch (type) {
            case COLLECTION: {
                this.folderPathCache.get().remove(id);
                break;
            }
            case RESOURCE: {
                this.docPathCache.get().remove(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Type " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void finish() throws OXException {
        this.clearCache();
        super.finish();
    }

    public void clearCache() {
        this.resolveCache.set(new HashMap());
        this.docPathCache.set((TIntObjectMap<WebdavPath>)new TIntObjectHashMap());
        this.folderPathCache.set((TIntObjectMap<WebdavPath>)new TIntObjectHashMap());
    }

    @Override
    public void startTransaction() throws OXException {
        super.startTransaction();
        this.resolveCache.set(new HashMap());
        this.docPathCache.set((TIntObjectMap<WebdavPath>)new TIntObjectHashMap());
        this.folderPathCache.set((TIntObjectMap<WebdavPath>)new TIntObjectHashMap());
    }

    private FolderObject getFolder(int folderid, Context ctx) throws OXException {
        return this.MODE.getFolder(folderid, ctx);
    }

    public void setAliases(WebdavFolderAliases aliases) {
        this.aliases = aliases;
    }

    private static final class NORMAL_MODE
    implements Mode {
        private NORMAL_MODE() {
        }

        @Override
        public FolderObject getFolder(int folderid, Context ctx) throws OXException {
            return FolderObject.loadFolderObjectFromDB(folderid, ctx);
        }
    }

    private final class CACHE_MODE
    implements Mode {
        private final DBProvider provider;

        public CACHE_MODE(DBProvider provider) {
            this.provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FolderObject getFolder(int folderid, Context ctx) throws OXException {
            try {
                Connection readCon = null;
                try {
                    readCon = this.provider.getReadConnection(ctx);
                    if (FolderCacheManager.isEnabled()) {
                        FolderObject folderObject = FolderCacheManager.getInstance().getFolderObject(folderid, true, ctx, readCon);
                        return folderObject;
                    }
                    FolderObject folderObject = FolderObject.loadFolderObjectFromDB(folderid, ctx, readCon);
                    return folderObject;
                }
                finally {
                    this.provider.releaseReadConnection(ctx, readCon);
                }
            }
            catch (OXException e) {
                PathResolverImpl.this.MODE = new NORMAL_MODE();
                return PathResolverImpl.this.MODE.getFolder(folderid, ctx);
            }
        }
    }

    static interface Mode {
        public FolderObject getFolder(int var1, Context var2) throws OXException;
    }
}

