/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.CreateTableService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.InfostoreAvailable;
import com.openexchange.groupware.infostore.database.impl.InfostoreFilenameReservationsCreateTableTask;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.LockCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.groupware.update.FullPrimaryKeySupportService;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.jslob.shared.SharedJSlobService;
import com.openexchange.server.services.SharedInfostoreJSlob;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreActivator
implements BundleActivator {
    public static final AtomicReference<InfostoreAvailable> INFOSTORE_FILE_STORAGE_AVAILABLE = new AtomicReference();
    private volatile Queue<ServiceRegistration<?>> registrations;
    private volatile ServiceTracker<FileStorageServiceRegistry, FileStorageServiceRegistry> tracker;
    private ServiceTracker<FullPrimaryKeySupportService, FullPrimaryKeySupportService> primaryKeyTracker;
    private ServiceTracker<ConfigurationService, ConfigurationService> configTracker;

    public void start(final BundleContext context) throws Exception {
        try {
            LockCleaner lockCleaner = new LockCleaner(new FolderLockManagerImpl(new DBPoolProvider()), new EntityLockManagerImpl(new DBPoolProvider(), "infostore_lock"));
            PropertyCleaner propertyCleaner = new PropertyCleaner(new PropertyStoreImpl(new DBPoolProvider(), "oxfolder_property"), new PropertyStoreImpl(new DBPoolProvider(), "infostore_property"));
            Hashtable<String, String> serviceProperties = new Hashtable<String, String>(1);
            ((Dictionary)serviceProperties).put("event.topics", "com/openexchange/groupware/infostore/*");
            LinkedList registrations = new LinkedList();
            registrations.offer(context.registerService(EventHandler.class, (Object)lockCleaner, serviceProperties));
            registrations.offer(context.registerService(EventHandler.class, (Object)propertyCleaner, serviceProperties));
            this.registrations = registrations;
            final class AvailableTracker
            extends ServiceTracker<FileStorageServiceRegistry, FileStorageServiceRegistry> {
                AvailableTracker(BundleContext context) {
                    super(context, FileStorageServiceRegistry.class, null);
                }

                public FileStorageServiceRegistry addingService(ServiceReference<FileStorageServiceRegistry> reference) {
                    final FileStorageServiceRegistry registry = (FileStorageServiceRegistry)super.addingService(reference);
                    INFOSTORE_FILE_STORAGE_AVAILABLE.set(new InfostoreAvailable(){

                        @Override
                        public boolean available() {
                            return registry.containsFileStorageService("com.openexchange.infostore");
                        }
                    });
                    return registry;
                }

                public void removedService(ServiceReference<FileStorageServiceRegistry> reference, FileStorageServiceRegistry service) {
                    INFOSTORE_FILE_STORAGE_AVAILABLE.set(null);
                    super.removedService(reference, (Object)service);
                }
            }
            AvailableTracker tracker = new AvailableTracker(context);
            tracker.open();
            this.tracker = tracker;
            this.primaryKeyTracker = new ServiceTracker(context, FullPrimaryKeySupportService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<FullPrimaryKeySupportService, FullPrimaryKeySupportService>(){

                public FullPrimaryKeySupportService addingService(ServiceReference<FullPrimaryKeySupportService> arg0) {
                    FullPrimaryKeySupportService service = (FullPrimaryKeySupportService)context.getService(arg0);
                    final InfostoreFilenameReservationsCreateTableTask task = new InfostoreFilenameReservationsCreateTableTask(service);
                    context.registerService(CreateTableService.class, (Object)task, null);
                    context.registerService(UpdateTaskProviderService.class.getName(), (Object)new UpdateTaskProviderService(){

                        public Collection<UpdateTaskV2> getUpdateTasks() {
                            return Arrays.asList(task);
                        }
                    }, null);
                    return service;
                }

                public void modifiedService(ServiceReference<FullPrimaryKeySupportService> arg0, FullPrimaryKeySupportService arg1) {
                }

                public void removedService(ServiceReference<FullPrimaryKeySupportService> arg0, FullPrimaryKeySupportService arg1) {
                    context.ungetService(arg0);
                }
            });
            this.primaryKeyTracker.open();
            this.configTracker = new ServiceTracker(context, ConfigurationService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationService, ConfigurationService>(){
                ServiceRegistration<SharedJSlobService> registration;

                public ConfigurationService addingService(ServiceReference<ConfigurationService> arg0) {
                    ConfigurationService configService = (ConfigurationService)context.getService(arg0);
                    SharedInfostoreJSlob infostoreJSlob = new SharedInfostoreJSlob();
                    this.registration = context.registerService(SharedJSlobService.class, (Object)infostoreJSlob, null);
                    return configService;
                }

                public void modifiedService(ServiceReference<ConfigurationService> arg0, ConfigurationService arg1) {
                }

                public void removedService(ServiceReference<ConfigurationService> arg0, ConfigurationService arg1) {
                    this.registration.unregister();
                    context.ungetService(arg0);
                }
            });
            this.configTracker.open();
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(InfostoreActivator.class);
            logger.error("Starting InfostoreActivator failed.", (Throwable)e);
            throw e;
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ServiceTracker<FileStorageServiceRegistry, FileStorageServiceRegistry> tracker = this.tracker;
            if (null != tracker) {
                tracker.close();
                this.tracker = null;
            }
            this.primaryKeyTracker.close();
            this.configTracker.close();
            Queue<ServiceRegistration<?>> registrations = this.registrations;
            if (null != registrations) {
                ServiceRegistration<?> polled;
                while ((polled = registrations.poll()) != null) {
                    polled.unregister();
                }
                this.registrations = null;
            }
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(InfostoreActivator.class);
            logger.error("Stopping InfostoreActivator failed.", (Throwable)e);
            throw e;
        }
    }
}

