/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreIterator
implements SearchIterator<DocumentMetadata> {
    private static final InfostoreQueryCatalog QUERIES = InfostoreFacadeImpl.QUERIES;
    private static final Logger LOG = LoggerFactory.getLogger(InfostoreIterator.class);
    private final Object[] args;
    private final DBProvider provider;
    private final String query;
    private boolean queried;
    private boolean initNext;
    private ResultSet rs;
    private boolean next;
    private OXException exception;
    private final List<OXException> warnings = new ArrayList<OXException>(2);
    private final Context ctx;
    private final Metadata[] fields;
    private final InfostoreQueryCatalog.FieldChooser chooser;

    public static InfostoreIterator loadDocumentIterator(int id, int version2, DBProvider provider, Context ctx) {
        String query = QUERIES.getSelectDocument(id, version2, ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, Metadata.VALUES_ARRAY, QUERIES.getChooserForVersion(version2), new Object[0]);
    }

    public static InfostoreIterator list(int[] id, Metadata[] metadata, DBProvider provider, Context ctx) {
        String query = QUERIES.getListQuery(id, metadata, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator documents(long folderId, Metadata[] metadata, Metadata sort, int order, DBProvider provider, Context ctx) {
        String query = QUERIES.getDocumentsQuery(folderId, metadata, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator documentsByCreator(long folderId, int userId, Metadata[] metadata, Metadata sort, int order, DBProvider provider, Context ctx) {
        String query = QUERIES.getDocumentsQuery(folderId, userId, metadata, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator versions(int id, Metadata[] metadata, Metadata sort, int order, DBProvider provider, Context ctx) {
        String query = QUERIES.getVersionsQuery(id, metadata, sort, order, new InfostoreQueryCatalog.VersionWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.VersionWins(), new Object[0]);
    }

    public static InfostoreIterator newDocuments(long folderId, Metadata[] metadata, Metadata sort, int order, long since, DBProvider provider, Context ctx) {
        String query = QUERIES.getNewDocumentsQuery(folderId, since, metadata, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator modifiedDocuments(long folderId, Metadata[] metadata, Metadata sort, int order, long since, DBProvider provider, Context ctx) {
        String query = QUERIES.getModifiedDocumentsQuery(folderId, since, metadata, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator deletedDocuments(long folderId, Metadata sort, int order, long since, DBProvider provider, Context ctx) {
        String query = QUERIES.getDeletedDocumentsQuery(folderId, since, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, new Metadata[]{Metadata.ID_LITERAL}, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator newDocumentsByCreator(long folderId, int userId, Metadata[] metadata, Metadata sort, int order, long since, DBProvider provider, Context ctx) {
        String query = QUERIES.getNewDocumentsQuery(folderId, userId, since, metadata, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator modifiedDocumentsByCreator(long folderId, int userId, Metadata[] metadata, Metadata sort, int order, long since, DBProvider provider, Context ctx) {
        String query = QUERIES.getModifiedDocumentsQuery(folderId, userId, since, metadata, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator deletedDocumentsByCreator(long folderId, int userId, Metadata sort, int order, long since, DBProvider provider, Context ctx) {
        String query = QUERIES.getDeletedDocumentsQuery(folderId, userId, since, sort, order, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, new Metadata[]{Metadata.ID_LITERAL}, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator allDocumentsWhere(String where, Metadata[] metadata, DBProvider provider, Context ctx) {
        String query = QUERIES.getAllDocumentsQuery(where, metadata, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), new Object[0]);
    }

    public static InfostoreIterator allVersionsWhere(String where, Metadata[] metadata, DBProvider provider, Context ctx) {
        String query = QUERIES.getAllVersionsQuery(where, metadata, new InfostoreQueryCatalog.VersionWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.VersionWins(), new Object[0]);
    }

    public static InfostoreIterator documentsByFilename(long folderId, String filename, Metadata[] metadata, DBProvider provider, Context ctx) {
        String query = QUERIES.getCurrentFilenameQuery(folderId, metadata, new InfostoreQueryCatalog.DocumentWins(), ctx.getContextId());
        return new InfostoreIterator(query, provider, ctx, metadata, new InfostoreQueryCatalog.DocumentWins(), filename);
    }

    protected InfostoreIterator(String query, DBProvider provider, Context ctx, Metadata[] fields, InfostoreQueryCatalog.FieldChooser chooser, Object ... args) {
        this.query = query;
        this.provider = provider;
        this.args = args;
        this.ctx = ctx;
        this.fields = fields;
        this.chooser = chooser;
    }

    public void close() throws OXException {
        if (this.rs == null) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = this.rs.getStatement();
            Connection con = stmt.getConnection();
            DBUtils.closeSQLStuff(this.rs, stmt);
            this.provider.releaseReadConnection(this.ctx, con);
            this.rs = null;
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
    }

    public boolean hasNext() throws OXException {
        if (!this.queried) {
            this.query();
        }
        if (this.exception != null) {
            return true;
        }
        if (this.initNext) {
            Statement stmt = null;
            try {
                stmt = this.rs.getStatement();
                this.next = this.rs.next();
                if (!this.next) {
                    this.close();
                }
            }
            catch (SQLException e) {
                this.exception = InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
        }
        this.initNext = false;
        return this.next;
    }

    public void addWarning(OXException warning) {
        this.warnings.add(warning);
    }

    public OXException[] getWarnings() {
        return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    private void query() {
        this.queried = true;
        this.initNext = true;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.provider.getReadConnection(this.ctx);
            stmt = con.prepareStatement(this.query);
            int i = 1;
            for (Object arg : this.args) {
                stmt.setObject(i++, arg);
            }
            LOG.trace("{}", (Object)stmt);
            this.rs = stmt.executeQuery();
        }
        catch (SQLException x) {
            if (stmt != null) {
                DBUtils.closeSQLStuff(null, stmt);
            }
            if (con != null) {
                this.provider.releaseReadConnection(this.ctx, con);
            }
            this.exception = InfostoreExceptionCodes.SQL_PROBLEM.create(x, DBUtils.getStatement(stmt, this.query));
        }
        catch (OXException e) {
            this.exception = e;
        }
    }

    public boolean hasSize() {
        return false;
    }

    public DocumentMetadata next() throws OXException {
        this.hasNext();
        if (this.exception != null) {
            throw this.exception;
        }
        this.initNext = true;
        return this.getDocument();
    }

    private DocumentMetadata getDocument() throws OXException {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        SetSwitch set = new SetSwitch(dm);
        StringBuilder sb = new StringBuilder(100);
        for (Metadata m : this.fields) {
            if (m == Metadata.CURRENT_VERSION_LITERAL) {
                Statement stmt = null;
                try {
                    stmt = this.rs.getStatement();
                    dm.setIsCurrentVersion(this.rs.getBoolean("current_version"));
                    continue;
                }
                catch (SQLException e) {
                    throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                }
            }
            InfostoreQueryCatalog.Table t = this.chooser.choose(m);
            String colName = (String)m.doSwitch(t.getFieldSwitcher());
            if (colName == null) continue;
            Statement stmt = null;
            try {
                stmt = this.rs.getStatement();
                set.setValue(this.process(m, this.rs.getObject(sb.append(t.getTablename()).append('.').append(colName).toString())));
                sb.setLength(0);
            }
            catch (SQLException e) {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            m.doSwitch(set);
        }
        return dm;
    }

    private Object process(Metadata m, Object object) {
        switch (m.getId()) {
            default: {
                return object;
            }
            case 4: 
            case 5: 
            case 6: {
                return new Date((Long)object);
            }
            case 1: 
            case 2: 
            case 3: 
            case 102: 
            case 705: 
        }
        return ((Long)object).intValue();
    }

    public int size() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DocumentMetadata> asList() throws OXException {
        try {
            ArrayList<DocumentMetadata> result = new ArrayList<DocumentMetadata>();
            while (this.hasNext()) {
                result.add(this.next());
            }
            ArrayList<DocumentMetadata> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }
}

