/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreConfig
extends AbstractConfig
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(InfostoreConfig.class);
    private static volatile InfostoreConfig singleton;
    private static boolean loaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InfostoreConfig getInstance() {
        InfostoreConfig ret = singleton;
        if (null != ret) return ret;
        Class<InfostoreConfig> clazz = InfostoreConfig.class;
        synchronized (InfostoreConfig.class) {
            ret = singleton;
            if (null != ret) return ret;
            singleton = ret = new InfostoreConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    private InfostoreConfig() {
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String filename;
        File file = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("infostore.properties");
        String string = filename = null == file ? null : file.getPath();
        if (null == filename) {
            throw new RuntimeException("Properties file 'infostore.properties' is not available.");
        }
        return filename;
    }

    public static String getProperty(String key) {
        InfostoreConfig singleton = InfostoreConfig.singleton;
        if (!loaded || singleton == null) {
            try {
                singleton = InfostoreConfig.getInstance();
                singleton.start();
            }
            catch (OXException e) {
                LOG.error("Can't init config:", (Throwable)e);
            }
        }
        return singleton.getPropertyInternal(key);
    }

    public static long getMaxUploadSize() {
        long size;
        String sizeS = InfostoreConfig.getProperty(InfoProperty.MAX_UPLOAD_SIZE.name());
        if (Strings.isEmpty((String)sizeS)) {
            return InfostoreConfig.sysconfMaxUpload();
        }
        try {
            size = Long.parseLong(sizeS.trim());
        }
        catch (NumberFormatException e) {
            LOG.warn("{} is not a number: {}. Fall-back to system upload limitation.", (Object)InfoProperty.MAX_UPLOAD_SIZE.name(), (Object)sizeS);
            size = -1L;
        }
        if (size < 0L) {
            return InfostoreConfig.sysconfMaxUpload();
        }
        return size;
    }

    private static long sysconfMaxUpload() {
        String sizeS = ServerConfig.getProperty(ServerConfig.Property.MAX_UPLOAD_SIZE);
        if (Strings.isEmpty((String)sizeS)) {
            return 0L;
        }
        try {
            return Long.parseLong(sizeS.trim());
        }
        catch (NumberFormatException e) {
            LOG.warn("{} is not a number: {}. Fall-back to no upload limitation for InfoStore module.", (Object)ServerConfig.Property.MAX_UPLOAD_SIZE.name(), (Object)sizeS);
            return 0L;
        }
    }

    public synchronized void start() throws OXException {
        if (!loaded || singleton == null) {
            InfostoreConfig.getInstance().loadPropertiesInternal();
            loaded = true;
        }
    }

    public synchronized void stop() throws OXException {
        singleton = null;
        loaded = false;
    }

    static {
        loaded = false;
    }

    public static enum InfoProperty {
        MAX_UPLOAD_SIZE;

    }
}

