/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;

public class CreatedByComparator
implements Comparator<DocumentMetadata> {
    private final TIntObjectMap<String> cache = new TIntObjectHashMap(24);
    private final Collator collator;
    private final Context context;
    private boolean desc;

    public CreatedByComparator(Locale locale, Context context) {
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
        this.context = context;
    }

    public CreatedByComparator setDescending(boolean desc) {
        this.desc = desc;
        return this;
    }

    @Override
    public int compare(DocumentMetadata o1, DocumentMetadata o2) {
        int result;
        int owner1 = o1.getCreatedBy();
        int owner2 = o2.getCreatedBy();
        if (owner1 > 0 && owner2 > 0) {
            result = this.collator.compare(this.getDisplayName(owner1), this.getDisplayName(owner2));
        } else {
            int n = owner1 < owner2 ? -1 : (result = owner1 == owner2 ? 0 : 1);
        }
        if (this.desc) {
            return result > 0 ? -1 : (result == 0 ? 0 : 1);
        }
        return result;
    }

    private String getDisplayName(int userId) {
        String displayName = (String)this.cache.get(userId);
        if (null == displayName) {
            try {
                displayName = UserStorage.getInstance().getUser(userId, this.context).getDisplayName();
            }
            catch (OXException e) {
                return null;
            }
            this.cache.put(userId, (Object)displayName);
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchIterator<DocumentMetadata> resort(SearchIterator<DocumentMetadata> iter, CreatedByComparator comparator) throws OXException {
        if (null == iter) {
            return iter;
        }
        boolean close = true;
        try {
            LinkedList<Object> files = new LinkedList<Object>();
            while (iter.hasNext()) {
                files.add(iter.next());
            }
            iter.close();
            close = false;
            Collections.sort(files, comparator);
            SearchIteratorDelegator searchIteratorDelegator = new SearchIteratorDelegator(files);
            return searchIteratorDelegator;
        }
        finally {
            if (close) {
                iter.close();
            }
        }
    }
}

