/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.container.Contact;
import com.openexchange.java.util.MsisdnCheck;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ContactUtil {
    private ContactUtil() {
    }

    public static void generateDisplayName(Contact contact) {
        boolean hasUsefulSureName;
        if (contact.containsDisplayName()) {
            return;
        }
        boolean hasUsefulGivenName = contact.containsGivenName() && contact.getGivenName() != null && contact.getGivenName().length() > 0;
        boolean bl = hasUsefulSureName = contact.containsSurName() && contact.getSurName() != null && contact.getSurName().length() > 0;
        if (hasUsefulGivenName || hasUsefulSureName) {
            StringBuilder sb = new StringBuilder();
            if (hasUsefulSureName) {
                sb.append(contact.getSurName());
            }
            if (hasUsefulGivenName && hasUsefulSureName) {
                sb.append(", ");
            }
            if (hasUsefulGivenName) {
                sb.append(contact.getGivenName());
            }
            contact.setDisplayName(sb.toString());
            return;
        }
        if (contact.containsCompany() && contact.getCompany() != null && contact.getCompany().length() > 0) {
            contact.setDisplayName(contact.getCompany());
            return;
        }
    }

    public static Set<String> gatherTelephoneNumbers(Contact contact) {
        if (null == contact) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(20);
        String tmp = contact.getCellularTelephone1();
        if (MsisdnCheck.checkMsisdn((String)tmp)) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getCellularTelephone2()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneAssistant()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneBusiness1()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneBusiness2()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneCallback()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneCar()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneCompany()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneHome1()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneHome2()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneIP()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneISDN()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneOther()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephonePager()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephonePrimary()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneRadio()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneTelex()))) {
            set.add(tmp);
        }
        if (MsisdnCheck.checkMsisdn((String)(tmp = contact.getTelephoneTTYTTD()))) {
            set.add(tmp);
        }
        return set;
    }
}

