/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class RepairRecurrencePatternNullValue
implements UpdateTask {
    private static final String[] STATEMENTS = new String[]{"UPDATE prg_dates SET field06 = ? WHERE field06 = ?", "UPDATE del_dates SET field06 = ? WHERE field06 = ?"};

    @Override
    public int addedWithVersion() {
        return 58;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            for (String statement : STATEMENTS) {
                this.executeStatement(con, statement);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(Connection con, String statement) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(statement);
            stmt.setNull(1, 12);
            stmt.setString(2, "null");
            stmt.execute();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

