/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.AttachmentWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="all", description="Get all Attachments for an Object.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="attached", description="The Object ID of the Object."), @Parameter(name="folder", description="The Folder ID of the Object."), @Parameter(name="module", description="The Module type of the Object."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for attachment's are defined in Common object data (with only id, created_by and creation_date available) and Attachment object."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="An array with attachment data. Each array element describes one attachment and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class AllAction
extends AbstractAttachmentAction {
    private static final Logger LOG = LoggerFactory.getLogger(AllAction.class);

    public AllAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            AllAction.require(requestData, "folder", "module", "attached");
            int folderId = this.requireNumber(requestData, "folder");
            int attachedId = this.requireNumber(requestData, "attached");
            int moduleId = this.requireNumber(requestData, "module");
            AttachmentField[] columns = PARSER.getColumns(requestData.getParameterValues("columns"));
            AttachmentField sort = null;
            if (null != requestData.getParameter("sort")) {
                sort = AttachmentField.get(Integer.parseInt(requestData.getParameter("sort")));
            }
            int order = 1;
            if ("DESC".equalsIgnoreCase(requestData.getParameter("order"))) {
                order = -1;
            }
            JSONValue jsonValue = this.all(session, folderId, attachedId, moduleId, columns, sort, order);
            return new AJAXRequestResult((Object)jsonValue, "apiResponse");
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (AttachmentParser.UnknownColumnException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)((Object)e), e.getMessage());
        }
    }

    private JSONValue all(ServerSession session, int folderId, int attachedId, int moduleId, AttachmentField[] fields, AttachmentField sort, int order) throws OXException {
        SearchIterator iter = null;
        try {
            ATTACHMENT_BASE.startTransaction();
            Context ctx = session.getContext();
            User user = session.getUser();
            UserConfiguration userConfig = session.getUserConfiguration();
            TimedResult<AttachmentMetadata> result = sort != null ? ATTACHMENT_BASE.getAttachments(session, folderId, attachedId, moduleId, fields, sort, order, ctx, user, userConfig) : ATTACHMENT_BASE.getAttachments(session, folderId, attachedId, moduleId, ctx, user, userConfig);
            iter = result.results();
            OXJSONWriter w = new OXJSONWriter();
            AttachmentWriter aWriter = new AttachmentWriter(w);
            aWriter.timedResult(result.sequenceNumber());
            aWriter.writeAttachments(iter, fields, TimeZoneUtils.getTimeZone(user.getTimeZone()));
            aWriter.endTimedResult();
            ATTACHMENT_BASE.commit();
            JSONValue jSONValue = w.getObject();
            return jSONValue;
        }
        catch (Throwable t) {
            this.rollback();
            if (t instanceof OXException) {
                throw (OXException)t;
            }
            throw new OXException(t);
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }
}

