/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;

public class CopyAttachmentsForChangeExceptions
implements CalendarListener {
    private final AttachmentBase attachmentBase;

    public CopyAttachmentsForChangeExceptions(AttachmentBase attachmentBase) {
        this.attachmentBase = attachmentBase;
    }

    @Override
    public void createdChangeExceptionInRecurringAppointment(Appointment master, Appointment exception, int inFolder, ServerSession session) throws OXException {
        try {
            this.attachmentBase.startTransaction();
            Context ctx = session.getContext();
            User userObject = UserStorage.getInstance().getUser(session.getUserId(), ctx);
            UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(session.getUserId(), ctx);
            TimedResult<AttachmentMetadata> result = this.attachmentBase.getAttachments(session, master.getParentFolderID(), master.getObjectID(), 1, ctx, userObject, userConfig);
            SearchIterator iterator = result.results();
            int folderId = exception.getParentFolderID();
            if (folderId == 0) {
                folderId = inFolder;
            }
            while (iterator.hasNext()) {
                AttachmentMetadata attachment = (AttachmentMetadata)iterator.next();
                AttachmentImpl copy = new AttachmentImpl(attachment);
                copy.setId(0);
                copy.setFileId(null);
                copy.setAttachedId(exception.getObjectID());
                copy.setFolderId(folderId);
                copy.setModuleId(1);
                InputStream is = this.attachmentBase.getAttachedFile(session, folderId, exception.getObjectID(), 1, attachment.getId(), ctx, userObject, userConfig);
                this.attachmentBase.attachToObject(copy, is, session, ctx, userObject, userConfig);
            }
            this.attachmentBase.commit();
        }
        catch (OXException x) {
            this.attachmentBase.rollback();
            throw x;
        }
        finally {
            this.attachmentBase.finish();
        }
    }
}

