/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupExceptionCodes;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.SQLStrings;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.LdapUtility;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class RdbGroupStorage
extends GroupStorage {
    private static final String SELECT_GROUPS = "SELECT id,identifier,displayName,lastModified FROM groups WHERE cid=?";
    private static final String SELECT_DELETED_GROUPS = "SELECT id,identifier,displayName,lastModified FROM del_groups WHERE cid=?";

    @Override
    public void insertGroup(Context ctx, Connection con, Group group, GroupStorage.StorageType type) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQLStrings.INSERT_GROUP.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, group.getIdentifier());
            stmt.setString(pos++, GroupStorage.StorageType.DELETED.equals((Object)type) ? "" : group.getSimpleName());
            stmt.setString(pos++, GroupStorage.StorageType.DELETED.equals((Object)type) ? "" : group.getDisplayName());
            stmt.setLong(pos++, group.getLastModified().getTime());
            stmt.setInt(pos++, 65534);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    @Override
    public void updateGroup(Context ctx, Connection con, Group group, Date lastRead) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE groups SET identifier=?,displayName=?,lastModified=? WHERE cid=? AND id=? AND lastModified<=?");
            int pos = 1;
            stmt.setString(pos++, group.getSimpleName());
            stmt.setString(pos++, group.getDisplayName());
            stmt.setLong(pos++, group.getLastModified().getTime());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, group.getIdentifier());
            stmt.setLong(pos++, lastRead.getTime());
            int rows = stmt.executeUpdate();
            if (1 != rows) {
                throw GroupExceptionCodes.MODIFIED.create();
            }
        }
        catch (SQLException e) {
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    @Override
    public void insertMember(Context ctx, Connection con, Group group, int[] members) throws OXException {
        if (0 == members.length) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO groups_member (cid,id,member) VALUES (?,?,?)");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, group.getIdentifier());
            for (int member : members) {
                stmt.setInt(3, member);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    @Override
    public void deleteMember(Context ctx, Connection con, Group group, int[] members) throws OXException {
        if (0 == members.length) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(DBUtils.getIN("DELETE FROM groups_member WHERE cid=? AND id=? AND member IN (", members.length));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, group.getIdentifier());
            for (int member : members) {
                stmt.setInt(pos++, member);
            }
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    @Override
    public void deleteGroup(Context ctx, Connection con, int groupId, Date lastRead) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM groups WHERE cid=? AND id=? AND lastModified<=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, groupId);
            stmt.setLong(3, lastRead.getTime());
            int rows = stmt.executeUpdate();
            if (1 != rows) {
                throw GroupExceptionCodes.MODIFIED.create();
            }
        }
        catch (SQLException e) {
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    @Override
    public Group getGroup(int gid, Context context) throws OXException {
        Connection con = DBPool.pickup(context);
        PreparedStatement stmt = null;
        ResultSet result = null;
        Group group = null;
        try {
            stmt = con.prepareStatement("SELECT id,identifier,displayName,lastModified FROM groups WHERE cid=? AND id = ?");
            stmt.setLong(1, context.getContextId());
            stmt.setInt(2, gid);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw LdapExceptionCode.GROUP_NOT_FOUND.create(gid, context.getContextId()).setPrefix("GRP");
            }
            group = new Group();
            int pos = 1;
            group.setIdentifier(result.getInt(pos++));
            group.setSimpleName(result.getString(pos++));
            group.setDisplayName(result.getString(pos++));
            group.setLastModified(new Date(result.getLong(pos++)));
            group.setMember(this.selectMember(con, context, group.getIdentifier()));
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("GRP");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return group;
    }

    @Override
    public Group[] listModifiedGroups(Date modifiedSince, Context context) throws OXException {
        return this.listModifiedOrDeletedGroups(modifiedSince, context, SELECT_GROUPS);
    }

    @Override
    public Group[] listDeletedGroups(Date modifiedSince, Context context) throws OXException {
        return this.listModifiedOrDeletedGroups(modifiedSince, context, SELECT_DELETED_GROUPS);
    }

    private Group[] listModifiedOrDeletedGroups(Date modifiedSince, Context context, String statement) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("GRP");
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        Group[] groups = null;
        try {
            stmt = con.prepareStatement(statement + " AND lastModified>?");
            stmt.setLong(1, context.getContextId());
            stmt.setLong(2, modifiedSince.getTime());
            result = stmt.executeQuery();
            ArrayList<Group> tmp = new ArrayList<Group>();
            while (result.next()) {
                Group group = new Group();
                int pos = 1;
                group.setIdentifier(result.getInt(pos++));
                group.setSimpleName(result.getString(pos++));
                group.setDisplayName(result.getString(pos++));
                group.setLastModified(new Date(result.getLong(pos++)));
                group.setMember(this.selectMember(con, context, group.getIdentifier()));
                tmp.add(group);
            }
            groups = tmp.toArray(new Group[tmp.size()]);
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("GRP");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return groups;
    }

    @Override
    public Group[] searchGroups(String pattern, boolean loadMembers, Context context) throws OXException {
        Group[] groupArray;
        Connection con;
        if (Strings.isEmpty((String)pattern)) {
            return new Group[0];
        }
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw GroupExceptionCodes.NO_CONNECTION.create(e, new Object[0]);
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT id,identifier,displayName,lastModified FROM groups WHERE cid=? AND (displayName LIKE ? OR identifier LIKE ?)");
            stmt.setLong(1, context.getContextId());
            String sqlPattern = LdapUtility.prepareSearchPattern(pattern);
            stmt.setString(2, sqlPattern);
            stmt.setString(3, sqlPattern);
            result = stmt.executeQuery();
            ArrayList<Group> groups = new ArrayList<Group>();
            while (result.next()) {
                Group group = new Group();
                int pos = 1;
                group.setIdentifier(result.getInt(pos++));
                group.setSimpleName(result.getString(pos++));
                group.setDisplayName(result.getString(pos++));
                group.setLastModified(new Date(result.getLong(pos++)));
                if (loadMembers) {
                    group.setMember(this.selectMember(con, context, group.getIdentifier()));
                }
                groups.add(group);
            }
            groupArray = groups.toArray(new Group[groups.size()]);
        }
        catch (SQLException e) {
            try {
                throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return groupArray;
    }

    @Override
    public Group[] getGroups(boolean loadMembers, Context context) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("GRP");
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        Group[] groups = null;
        try {
            stmt = con.prepareStatement(SELECT_GROUPS);
            stmt.setLong(1, context.getContextId());
            result = stmt.executeQuery();
            ArrayList<Group> tmp = new ArrayList<Group>();
            while (result.next()) {
                Group group = new Group();
                int pos = 1;
                group.setIdentifier(result.getInt(pos++));
                group.setSimpleName(result.getString(pos++));
                group.setDisplayName(result.getString(pos++));
                group.setLastModified(new Date(result.getLong(pos++)));
                if (loadMembers) {
                    group.setMember(this.selectMember(con, context, group.getIdentifier()));
                }
                tmp.add(group);
            }
            groups = tmp.toArray(new Group[tmp.size()]);
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("GRP");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] selectMember(Connection con, Context ctx, int groupId) throws SQLException {
        String getMember = "SELECT member FROM groups_member WHERE cid=? AND id=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        try {
            stmt = con.prepareStatement("SELECT member FROM groups_member WHERE cid=? AND id=?");
            stmt.setLong(1, ctx.getContextId());
            stmt.setInt(2, groupId);
            result = stmt.executeQuery();
            while (result.next()) {
                tmp.add(result.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
        int[] member = new int[tmp.size()];
        for (int i = 0; i < member.length; ++i) {
            member[i] = (Integer)tmp.get(i);
        }
        return member;
    }
}

