/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.outlook.OutlookFolder;
import com.openexchange.folderstorage.outlook.OutlookPermission;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Select {
    private static final String SQL_SELECT = "SELECT parentId, name, modifiedBy, lastModified FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_BCK = "SELECT parentId, name, modifiedBy, lastModified FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT2 = "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT2_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT3 = "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT3_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT_BY_NAME = "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ? AND name = ?";
    private static final String SQL_SELECT_BY_NAME_BCK = "SELECT folderId FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ? AND name = ?";
    private static final String SQL_SELECT_SUBF = "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT_SUBF_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT_PERMS = "SELECT entity, groupFlag, fp, orp, owp, odp, adminFlag, system FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_PERMS_BCK = "SELECT entity, groupFlag, fp, orp, owp, odp, adminFlag, system FROM virtualBackupPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_SUBSCRIPTION = "SELECT subscribed FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT_SUBSCRIPTION_BCK = "SELECT subscribed FROM virtualBackupSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_SELECT2_SUBF = "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_SELECT2_SUBF_BCK = "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?";
    private static final String SQL_TEMPL_SUBSR_SUBF = "SELECT t.folderId, s.subscribed FROM #T# as t LEFT JOIN #S# as s ON t.cid = s.cid AND t.tree = s.tree AND t.user = s.user AND t.folderId = s.folderId WHERE t.cid = ? AND t.tree = ? AND t.user = ? and t.parentId = ?";
    private static final String SQL_SELECT_ALL = "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ?";

    private Select() {
    }

    public static String getByName(int cid, int tree, int user, String parentId, String name, StorageType storageType) throws OXException {
        String string;
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? SQL_SELECT_BY_NAME : SQL_SELECT_BY_NAME_BCK);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos++, parentId);
            stmt.setString(pos, name);
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                databaseService.backReadOnly(cid, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        databaseService.backReadOnly(cid, con);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsParent(int cid, int tree, int user, String parentId, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            boolean bl = Select.containsParent(cid, tree, user, parentId, storageType, con);
            return bl;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsParent(int cid, int tree, int user, String parentId, StorageType storageType, Connection con) throws OXException {
        boolean bl;
        if (null == con) {
            return Select.containsParent(cid, tree, user, parentId, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?" : "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, parentId);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsFolder(int cid, int tree, int user, String folderId, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            boolean bl = Select.containsFolder(cid, tree, user, folderId, storageType, con);
            return bl;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsFolder(int cid, int tree, int user, String folderId, StorageType storageType, Connection con) throws OXException {
        boolean bl;
        if (null == con) {
            return Select.containsFolder(cid, tree, user, folderId, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? SQL_SELECT2 : SQL_SELECT2_BCK);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFolderName(int cid, int tree, int user, String folderId, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            String string = Select.getFolderName(cid, tree, user, folderId, storageType, con);
            return string;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFolderName(int cid, int tree, int user, String folderId, StorageType storageType, Connection con) throws OXException {
        String string;
        if (null == con) {
            return Select.getFolderName(cid, tree, user, folderId, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? SQL_SELECT2 : SQL_SELECT2_BCK);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(2) : null;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] containsFolders(int cid, int tree, int user, String[] folderIds, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            boolean[] blArray = Select.containsFolders(cid, tree, user, folderIds, storageType, con);
            return blArray;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean[] containsFolders(int cid, int tree, int user, String[] folderIds, StorageType storageType, Connection con) throws OXException {
        boolean[] blArray;
        if (null == con) {
            return Select.containsFolders(cid, tree, user, folderIds, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean[] ret = new boolean[folderIds.length];
            for (int i = 0; i < ret.length; ++i) {
                stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? SQL_SELECT2 : SQL_SELECT2_BCK);
                int pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderIds[i]);
                rs = stmt.executeQuery();
                ret[i] = rs.next();
                DBUtils.closeSQLStuff(rs, stmt);
            }
            stmt = null;
            rs = null;
            blArray = ret;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] containsFolders(int cid, int tree, int user, SortableId[] folderIds, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            boolean[] blArray = Select.containsFolders(cid, tree, user, folderIds, storageType, con);
            return blArray;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean[] containsFolders(int cid, int tree, int user, SortableId[] folderIds, StorageType storageType, Connection con) throws OXException {
        boolean[] blArray;
        if (null == con) {
            return Select.containsFolders(cid, tree, user, folderIds, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean[] ret = new boolean[folderIds.length];
            for (int i = 0; i < ret.length; ++i) {
                stmt = con.prepareStatement(StorageType.WORKING.equals(storageType) ? SQL_SELECT2 : SQL_SELECT2_BCK);
                int pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderIds[i].getId());
                rs = stmt.executeQuery();
                ret[i] = rs.next();
                DBUtils.closeSQLStuff(rs, stmt);
            }
            stmt = null;
            rs = null;
            blArray = ret;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return blArray;
    }

    public static boolean fillFolder(int cid, int tree, int user, Locale locale, OutlookFolder outlookFolder, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            boolean bl = Select.fillFolder(cid, tree, user, locale, outlookFolder, storageType, con);
            return bl;
        }
        catch (Exception e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    public static boolean fillFolder(int cid, int tree, int user, Locale locale, OutlookFolder outlookFolder, StorageType storageType, Connection con) throws OXException {
        String sql;
        int pos;
        boolean working;
        ResultSet rs;
        PreparedStatement stmt;
        String folderId;
        block37: {
            block36: {
                if (null == con) {
                    return Select.fillFolder(cid, tree, user, locale, outlookFolder, storageType);
                }
                folderId = outlookFolder.getID();
                stmt = null;
                rs = null;
                working = StorageType.WORKING.equals(storageType);
                stmt = con.prepareStatement(working ? SQL_SELECT : SQL_SELECT_BCK);
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                rs = stmt.executeQuery();
                if (rs.next()) break block36;
                boolean bl = false;
                DBUtils.closeSQLStuff(rs, stmt);
                return bl;
            }
            try {
                pos = 1;
                outlookFolder.setParentID(rs.getString(pos++));
                String name = rs.getString(pos++);
                if (!rs.wasNull()) {
                    outlookFolder.setName(name);
                }
                int modifiedBy = rs.getInt(pos++);
                if (rs.wasNull()) {
                    outlookFolder.setModifiedBy(-1);
                } else {
                    outlookFolder.setModifiedBy(modifiedBy);
                }
                long date = rs.getLong(pos);
                if (rs.wasNull()) {
                    outlookFolder.setLastModified(null);
                    break block37;
                }
                outlookFolder.setLastModified(new Date(date));
            }
            catch (SQLException e) {
                try {
                    Logger LOG;
                    if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                        String sql2 = Select.getSQLString(stmt);
                        LOG.debug("Failed SQL:\n\t{}", (Object)sql2);
                    }
                    throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        stmt = null;
        try {
            stmt = con.prepareStatement(working ? SQL_SELECT_PERMS : SQL_SELECT_PERMS_BCK);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            rs = stmt.executeQuery();
            ArrayList<OutlookPermission> permissions = new ArrayList<OutlookPermission>();
            while (rs.next()) {
                OutlookPermission p = new OutlookPermission();
                pos = 1;
                p.setEntity(rs.getInt(pos++));
                p.setGroup(rs.getInt(pos++) > 0);
                p.setFolderPermission(rs.getInt(pos++));
                p.setReadPermission(rs.getInt(pos++));
                p.setWritePermission(rs.getInt(pos++));
                p.setDeletePermission(rs.getInt(pos++));
                p.setAdmin(rs.getInt(pos++) > 0);
                p.setSystem(rs.getInt(pos++));
                permissions.add(p);
            }
            if (permissions.isEmpty()) {
                outlookFolder.setPermissions(null);
            } else {
                outlookFolder.setPermissions(permissions.toArray(new Permission[permissions.size()]));
            }
        }
        catch (SQLException e) {
            Logger LOG;
            if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                String sql3 = Select.getSQLString(stmt);
                LOG.debug("Failed SQL:\n\t{}", (Object)sql3);
            }
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
        }
        stmt = null;
        try {
            stmt = con.prepareStatement(working ? SQL_SELECT_SUBSCRIPTION : SQL_SELECT_SUBSCRIPTION_BCK);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            rs = stmt.executeQuery();
            pos = 1;
            boolean subscribed = true;
            if (rs.next()) {
                subscribed = rs.getInt(pos) > 0;
            }
            outlookFolder.setSubscribed(subscribed);
        }
        catch (SQLException e) {
            Logger LOG;
            if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                sql = Select.getSQLString(stmt);
                LOG.debug("Failed SQL:\n\t{}", (Object)sql);
            }
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
        }
        stmt = null;
        try {
            String sql4 = working ? SQL_TEMPL_SUBSR_SUBF.replaceFirst("#T#", "virtualTree").replaceFirst("#S#", "virtualSubscription") : SQL_TEMPL_SUBSR_SUBF.replaceFirst("#T#", "virtualBackupTree").replaceFirst("#S#", "virtualBackupSubscription");
            stmt = con.prepareStatement(sql4);
            int pos2 = 1;
            stmt.setInt(pos2++, cid);
            stmt.setInt(pos2++, tree);
            stmt.setInt(pos2++, user);
            stmt.setString(pos2, folderId);
            rs = stmt.executeQuery();
            pos2 = 2;
            boolean subscribedSubfolder = false;
            while (!subscribedSubfolder && rs.next()) {
                int subfolderSubscription = rs.getInt(pos2);
                if (rs.wasNull()) {
                    subscribedSubfolder = true;
                    continue;
                }
                subscribedSubfolder = subfolderSubscription > 0;
            }
            if (subscribedSubfolder) {
                outlookFolder.setSubscribedSubfolders(true);
            }
        }
        catch (SQLException e) {
            Logger LOG;
            if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                sql = Select.getSQLString(stmt);
                LOG.debug("Failed SQL:\n\t{}", (Object)sql);
            }
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSubfolderIds(int cid, int tree, int user, Locale locale, String parentId, List<String[]> realSubfolderIds, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            String[] stringArray = Select.getSubfolderIds(cid, tree, user, locale, parentId, realSubfolderIds, storageType, con);
            return stringArray;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    public static String[] getSubfolderIds(int cid, int tree, int user, Locale locale, String parentId, List<String[]> realSubfolderIds, StorageType storageType, Connection con) throws OXException {
        String[] stringArray;
        if (null == con) {
            return Select.getSubfolderIds(cid, tree, user, locale, parentId, realSubfolderIds, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> subfolderIds;
            boolean working = StorageType.WORKING.equals(storageType);
            stmt = con.prepareStatement(working ? "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?" : "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, parentId);
            rs = stmt.executeQuery();
            pos = 1;
            if (FolderStorage.ROOT_ID.equals(parentId)) {
                ArrayList<String[]> fns = new ArrayList<String[]>();
                while (rs.next()) {
                    String[] sa = new String[]{rs.getString(pos), rs.getString(2)};
                    fns.add(sa);
                }
                Collections.sort(fns, new PrivateSubfolderIDComparator(locale));
                subfolderIds = new ArrayList<String>(fns.size());
                for (String[] fn : fns) {
                    subfolderIds.add(fn[0]);
                }
            } else {
                TreeMap treeMap = new TreeMap(new FolderNameComparator(locale));
                StringHelper stringHelper = StringHelper.valueOf(locale);
                for (String[] realSubfolderId : realSubfolderIds) {
                    String localizedName = stringHelper.getString(realSubfolderId[1]);
                    ArrayList<String> list = (ArrayList<String>)treeMap.get(localizedName);
                    if (null == list) {
                        list = new ArrayList<String>(2);
                        treeMap.put(localizedName, list);
                    }
                    list.add(realSubfolderId[0]);
                }
                while (rs.next()) {
                    String name = rs.getString(2);
                    List list = (ArrayList<String>)treeMap.get(name);
                    if (null == list) {
                        list = new ArrayList<String>(2);
                        treeMap.put(name, list);
                    }
                    list.add(rs.getString(pos));
                }
                subfolderIds = new ArrayList(treeMap.size());
                for (List list : treeMap.values()) {
                    for (String name : list) {
                        subfolderIds.add(name);
                    }
                }
            }
            stringArray = subfolderIds.toArray(new String[subfolderIds.size()]);
        }
        catch (SQLException e) {
            try {
                Logger LOG;
                if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                    String sql = Select.getSQLString(stmt);
                    LOG.debug("Failed SQL:\n\t{}", (Object)sql);
                }
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFolders(int cid, int tree, int user) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            List<String> list = Select.getFolders(cid, tree, user, con);
            return list;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getFolders(int cid, int tree, int user, Connection con) throws OXException {
        ArrayList<String> arrayList;
        if (null == con) {
            return Select.getFolders(cid, tree, user);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_ALL);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            rs = stmt.executeQuery();
            ArrayList<String> l = new ArrayList<String>();
            boolean fpos = true;
            while (rs.next()) {
                l.add(rs.getString(1));
            }
            arrayList = l;
        }
        catch (SQLException e) {
            try {
                Logger LOG;
                if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                    String sql = Select.getSQLString(stmt);
                    LOG.debug("Failed SQL:\n\t{}", (Object)sql);
                }
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getSubfolderIds(int cid, int tree, int user, String parentId, StorageType storageType) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(cid);
        try {
            List<String[]> list = Select.getSubfolderIds(cid, tree, user, parentId, storageType, con);
            return list;
        }
        finally {
            databaseService.backReadOnly(cid, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> getSubfolderIds(int cid, int tree, int user, String parentId, StorageType storageType, Connection con) throws OXException {
        ArrayList<String[]> arrayList;
        if (null == con) {
            return Select.getSubfolderIds(cid, tree, user, parentId, storageType);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean working = StorageType.WORKING.equals(storageType);
            stmt = con.prepareStatement(working ? "SELECT folderId, name FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?" : "SELECT folderId, name FROM virtualBackupTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, parentId);
            rs = stmt.executeQuery();
            ArrayList<String[]> l = new ArrayList<String[]>();
            boolean fpos = true;
            int spos = 2;
            while (rs.next()) {
                l.add(new String[]{rs.getString(1), rs.getString(2)});
            }
            arrayList = l;
        }
        catch (SQLException e) {
            try {
                Logger LOG;
                if (null != stmt && (LOG = LoggerFactory.getLogger(Select.class)).isDebugEnabled()) {
                    String sql = Select.getSQLString(stmt);
                    LOG.debug("Failed SQL:\n\t{}", (Object)sql);
                }
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return arrayList;
    }

    private static String getSQLString(PreparedStatement stmt) {
        String toString = stmt.toString();
        return toString.substring(toString.indexOf(": ") + 2);
    }

    private static final class PrivateSubfolderIDComparator
    implements Comparator<String[]> {
        private final Collator collator;

        public PrivateSubfolderIDComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            String privateId = "1";
            Integer privateComp = this.conditionalCompare("1".equals(o1[0]), "1".equals(o2[0]));
            if (null != privateComp) {
                return privateComp;
            }
            String publicId = "2";
            Integer publicComp = this.conditionalCompare("2".equals(o1[0]), "2".equals(o2[0]));
            if (null != publicComp) {
                return publicComp;
            }
            String sharedId = "3";
            Integer sharedComp = this.conditionalCompare("3".equals(o1[0]), "3".equals(o2[0]));
            if (null != sharedComp) {
                return sharedComp;
            }
            String uiName = "Unified Inbox";
            Integer unifiedInboxComp = this.conditionalCompare("Unified Inbox".equalsIgnoreCase(o1[1]), "Unified Inbox".equalsIgnoreCase(o2[1]));
            if (null != unifiedInboxComp) {
                return unifiedInboxComp;
            }
            return this.collator.compare(o1[1], o2[1]);
        }

        private Integer conditionalCompare(boolean b1, boolean b2) {
            if (b1) {
                if (!b2) {
                    return -1;
                }
                return 0;
            }
            if (b2) {
                return 1;
            }
            return null;
        }
    }

    public static final class FolderNameComparator
    implements Comparator<String> {
        private final Collator collator;

        public FolderNameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String o1, String o2) {
            return this.collator.compare(o1, o2);
        }
    }
}

