/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.FolderEventConstants;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.outlook.OutlookFolderStorage;
import com.openexchange.folderstorage.outlook.OutlookServiceRegistry;
import com.openexchange.folderstorage.outlook.memory.MemoryTable;
import com.openexchange.folderstorage.outlook.osgi.OutlookFolderStorageServiceTracker;
import com.openexchange.folderstorage.outlook.sql.Update;
import com.openexchange.mailaccount.MailAccountDeleteListener;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.push.PushEventConstants;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.ThreadPoolService;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookFolderStorageActivator
extends DeferredActivator {
    static final Logger LOG = LoggerFactory.getLogger(OutlookFolderStorageActivator.class);
    private List<ServiceRegistration<?>> serviceRegistrations;
    private List<ServiceTracker<?, ?>> serviceTrackers;

    protected Class<?>[] getNeededServices() {
        return new Class[]{DatabaseService.class, MailAccountStorageService.class, ThreadPoolService.class, MessagingServiceRegistry.class, UnifiedInboxManagement.class, ConfigurationService.class, FileStorageServiceRegistry.class, SessiondService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        LOG.info("Re-available service: {}", (Object)clazz.getName());
        OutlookServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    protected void handleUnavailability(Class<?> clazz) {
        LOG.warn("Absent service: {}", (Object)clazz.getName());
        OutlookServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = OutlookServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.serviceTrackers = new ArrayList(1);
            this.serviceTrackers.add(new ServiceTracker(this.context, FolderStorage.class, (ServiceTrackerCustomizer)new OutlookFolderStorageServiceTracker(this.context)));
            for (ServiceTracker<?, ?> serviceTracker : this.serviceTrackers) {
                serviceTracker.open();
            }
            this.serviceRegistrations = new ArrayList(2);
            this.serviceRegistrations.add(this.context.registerService(MailAccountDeleteListener.class, (Object)new MailAccountDeleteListener(){

                @Override
                public void onBeforeMailAccountDeletion(int id, Map<String, Object> eventProps, int user, int cid, Connection con) throws OXException {
                    OutlookFolderStorage.clearTCM();
                }

                @Override
                public void onAfterMailAccountDeletion(int id, Map<String, Object> eventProps, int user, int cid, Connection con) throws OXException {
                }
            }, null));
            Hashtable<String, String> dictionary = new Hashtable<String, String>(1);
            ((Dictionary)dictionary).put("tree", "1");
            this.serviceRegistrations.add(this.context.registerService(FolderStorage.class, (Object)OutlookFolderStorage.getInstance(), dictionary));
            EventHandler pushMailEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    OutlookFolderStorage.clearTCM();
                }
            };
            Hashtable<String, String[]> dict = new Hashtable<String, String[]>(1);
            ((Dictionary)dict).put("event.topics", PushEventConstants.getAllTopics());
            this.serviceRegistrations.add(this.context.registerService(EventHandler.class, (Object)pushMailEventHandler, dict));
            EventHandler folderEventHandler = new EventHandler(){
                private final int tree = Integer.parseInt("1");

                public void handleEvent(Event event) {
                    OutlookFolderStorage.clearTCM();
                    if ("com/openexchange/folderstorage/identifiers".equals(event.getTopic())) {
                        Session session = (Session)event.getProperty("com.openexchange.folderstorage.session");
                        String newId = (String)event.getProperty("com.openexchange.folderstorage.newIdentifier");
                        String oldId = (String)event.getProperty("com.openexchange.folderstorage.oldIdentifier");
                        String delim = (String)event.getProperty("com.openexchange.folderstorage.delimiter");
                        try {
                            Update.updateIds(session.getContextId(), this.tree, session.getUserId(), newId, oldId, delim);
                        }
                        catch (Exception e) {
                            LOG.error("", (Throwable)e);
                        }
                        MemoryTable memoryTable = MemoryTable.optMemoryTableFor(session);
                        if (null != memoryTable) {
                            try {
                                memoryTable.initializeTree(this.tree, session.getUserId(), session.getContextId());
                            }
                            catch (Exception e) {
                                LOG.error("", (Throwable)e);
                            }
                        }
                    }
                }
            };
            dict = new Hashtable(1);
            ((Dictionary)dict).put("event.topics", FolderEventConstants.getAllTopics());
            this.serviceRegistrations.add(this.context.registerService(EventHandler.class.getName(), (Object)folderEventHandler, dict));
            EventHandler sessionEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    block3: {
                        String topic;
                        block4: {
                            block2: {
                                topic = event.getTopic();
                                if (!"com/openexchange/sessiond/remove/data".equals(topic)) break block2;
                                Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                                for (Session session : container.values()) {
                                    this.dropMemoryTable(session);
                                }
                                break block3;
                            }
                            if (!"com/openexchange/sessiond/remove/session".equals(topic)) break block4;
                            this.dropMemoryTable((Session)event.getProperty("com.openexchange.sessiond.session"));
                            break block3;
                        }
                        if (!"com/openexchange/sessiond/remove/container".equals(topic)) break block3;
                        Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                        for (Session session : container.values()) {
                            this.dropMemoryTable(session);
                        }
                    }
                }

                private void dropMemoryTable(Session session) {
                    if (session.isTransient()) {
                        return;
                    }
                    SessiondService service = (SessiondService)OutlookServiceRegistry.getServiceRegistry().getService(SessiondService.class);
                    if (null == service.getAnyActiveSessionForUser(session.getUserId(), session.getContextId())) {
                        MemoryTable.dropMemoryTableFrom(session);
                    }
                }
            };
            dict = new Hashtable(1);
            ((Dictionary)dict).put("event.topics", SessiondEventConstants.getAllTopics());
            this.serviceRegistrations.add(this.context.registerService(EventHandler.class.getName(), (Object)sessionEventHandler, dict));
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            if (null != this.serviceRegistrations) {
                for (ServiceRegistration<?> serviceRegistration : this.serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                this.serviceRegistrations.clear();
                this.serviceRegistrations = null;
            }
            if (null != this.serviceTrackers) {
                for (ServiceTracker serviceTracker : this.serviceTrackers) {
                    serviceTracker.close();
                }
                this.serviceTrackers.clear();
                this.serviceTrackers = null;
            }
            OutlookServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }
}

