/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.memory;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.outlook.memory.MemoryFolder;
import com.openexchange.folderstorage.outlook.memory.MemoryPermission;
import com.openexchange.folderstorage.outlook.memory.MemoryTree;
import com.openexchange.folderstorage.outlook.memory.impl.MemoryFolderImpl;
import com.openexchange.folderstorage.outlook.memory.impl.MemoryTreeImpl;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MemoryTable {
    private static final ConcurrentMap<Key, MemoryTable> MAP = new ConcurrentHashMap<Key, MemoryTable>(1024);
    private final ConcurrentTIntObjectHashMap<MemoryTree> treeMap = new ConcurrentTIntObjectHashMap();

    public static MemoryTable getMemoryTableFor(Session session) throws OXException {
        return MemoryTable.getMemoryTableFor(session, true);
    }

    public static MemoryTable optMemoryTableFor(Session session) {
        try {
            return MemoryTable.getMemoryTableFor(session, false);
        }
        catch (OXException e) {
            return null;
        }
    }

    private static MemoryTable getMemoryTableFor(Session session, boolean createIfAbsent) throws OXException {
        return MemoryTable.getMemoryTable0(session, createIfAbsent);
    }

    private static MemoryTable getMemoryTable0(Session session, boolean createIfAbsent) throws OXException {
        Key key = MemoryTable.keyFor(session);
        MemoryTable memoryTable = (MemoryTable)MAP.get(key);
        if (null != memoryTable) {
            return memoryTable;
        }
        if (!createIfAbsent) {
            return null;
        }
        MemoryTable nuMemoryTable = new MemoryTable();
        nuMemoryTable.initialize(session.getUserId(), session.getContextId());
        memoryTable = MAP.putIfAbsent(key, nuMemoryTable);
        if (null == memoryTable) {
            memoryTable = nuMemoryTable;
        }
        return memoryTable;
    }

    public static void dropMemoryTableFrom(Session session) {
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (service.getAnyActiveSessionForUser(session.getUserId(), session.getContextId()) == null) {
            MAP.remove(MemoryTable.keyFor(session));
        }
    }

    private MemoryTable() {
    }

    public void clear() {
        this.treeMap.clear();
    }

    public boolean containsTree(int treeId) {
        return this.treeMap.containsKey(treeId);
    }

    public MemoryTree getTree(int treeId, Session session) throws OXException {
        return this.getTree(treeId, session.getUserId(), session.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryTree getTree(int treeId, int userId, int contextId) throws OXException {
        MemoryTree memoryTree = (MemoryTree)this.treeMap.get(treeId);
        if (null == memoryTree) {
            ConcurrentTIntObjectHashMap<MemoryTree> concurrentTIntObjectHashMap = this.treeMap;
            synchronized (concurrentTIntObjectHashMap) {
                memoryTree = (MemoryTree)this.treeMap.get(treeId);
                if (null == memoryTree) {
                    memoryTree = this.initializeTree(treeId, userId, contextId);
                }
            }
        }
        return memoryTree;
    }

    public MemoryTree optTree(int treeId) {
        return (MemoryTree)this.treeMap.get(treeId);
    }

    public boolean isEmpty() {
        return this.treeMap.isEmpty();
    }

    public MemoryTree remove(int treeId) {
        return (MemoryTree)this.treeMap.remove(treeId);
    }

    public int size() {
        return this.treeMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(int userId, int contextId) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(contextId);
        try {
            this.initialize(userId, contextId, con);
        }
        finally {
            databaseService.backReadOnly(contextId, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(int userId, int contextId, Connection con) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        block14: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT t.tree, t.folderId, t.parentId, t.name, t.lastModified, t.modifiedBy, s.subscribed, t.sortNum FROM virtualTree AS t LEFT JOIN virtualSubscription AS s ON t.cid = s.cid AND t.tree = s.tree AND t.user = s.user AND t.folderId = s.folderId WHERE t.cid = ? AND t.user = ? ORDER BY t.tree");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (rs.next()) break block14;
            DBUtils.closeSQLStuff(rs, stmt);
            return;
        }
        try {
            int tree = rs.getInt(1);
            MemoryTreeImpl memoryTree = new MemoryTreeImpl(tree);
            this.treeMap.put(tree, (Object)memoryTree);
            do {
                int tid;
                if (tree != (tid = rs.getInt(1))) {
                    tree = tid;
                    memoryTree = new MemoryTreeImpl(tree);
                    this.treeMap.put(tree, (Object)memoryTree);
                }
                MemoryFolderImpl memoryFolder = new MemoryFolderImpl();
                memoryFolder.setId(rs.getString(2));
                int modifiedBy = rs.getInt(6);
                if (rs.wasNull()) {
                    memoryFolder.setModifiedBy(-1);
                } else {
                    memoryFolder.setModifiedBy(modifiedBy);
                }
                long date = rs.getLong(5);
                if (rs.wasNull()) {
                    memoryFolder.setLastModified(null);
                } else {
                    memoryFolder.setLastModified(new Date(date));
                }
                memoryFolder.setName(rs.getString(4));
                memoryFolder.setParentId(rs.getString(3));
                int subscribed = rs.getInt(7);
                if (!rs.wasNull()) {
                    memoryFolder.setSubscribed(subscribed > 0);
                }
                int sortNum = rs.getInt(8);
                if (!rs.wasNull()) {
                    memoryFolder.setSortNum(sortNum);
                }
                MemoryTable.addPermissions(memoryFolder, tree, userId, contextId, con);
                memoryTree.getCrud().put(memoryFolder);
            } while (rs.next());
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryTree initializeTree(int treeId, int userId, int contextId) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getReadOnly(contextId);
        try {
            MemoryTree memoryTree = this.initializeTree(treeId, userId, contextId, con);
            return memoryTree;
        }
        finally {
            databaseService.backReadOnly(contextId, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MemoryTree initializeTree(int treeId, int userId, int contextId, Connection con) throws OXException {
        MemoryTreeImpl memoryTreeImpl;
        MemoryTreeImpl memoryTree;
        ResultSet rs;
        PreparedStatement stmt;
        block14: {
            if (null == con) {
                return this.initializeTree(treeId, userId, contextId);
            }
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT t.folderId, t.parentId, t.name, t.lastModified, t.modifiedBy, s.subscribed, t.sortNum FROM virtualTree AS t LEFT JOIN virtualSubscription AS s ON t.cid = s.cid AND t.tree = s.tree AND t.user = s.user AND t.folderId = s.folderId WHERE t.cid = ? AND t.user = ? AND t.tree = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setInt(3, treeId);
            rs = stmt.executeQuery();
            memoryTree = new MemoryTreeImpl(treeId);
            if (rs.next()) break block14;
            this.treeMap.put(treeId, (Object)memoryTree);
            MemoryTreeImpl memoryTreeImpl2 = memoryTree;
            DBUtils.closeSQLStuff(rs, stmt);
            return memoryTreeImpl2;
        }
        try {
            do {
                MemoryFolderImpl memoryFolder = new MemoryFolderImpl();
                memoryFolder.setId(rs.getString(1));
                int modifiedBy = rs.getInt(5);
                if (rs.wasNull()) {
                    memoryFolder.setModifiedBy(-1);
                } else {
                    memoryFolder.setModifiedBy(modifiedBy);
                }
                long date = rs.getLong(4);
                if (rs.wasNull()) {
                    memoryFolder.setLastModified(null);
                } else {
                    memoryFolder.setLastModified(new Date(date));
                }
                memoryFolder.setName(rs.getString(3));
                memoryFolder.setParentId(rs.getString(2));
                int subscribed = rs.getInt(6);
                if (!rs.wasNull()) {
                    memoryFolder.setSubscribed(subscribed > 0);
                }
                int sortNum = rs.getInt(7);
                if (!rs.wasNull()) {
                    memoryFolder.setSortNum(sortNum);
                }
                MemoryTable.addPermissions(memoryFolder, treeId, userId, contextId, con);
                memoryTree.getCrud().put(memoryFolder);
            } while (rs.next());
            this.treeMap.put(treeId, (Object)memoryTree);
            memoryTreeImpl = memoryTree;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return memoryTreeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryFolder initializeFolder(String folderId, int treeId, int userId, int contextId) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getWritable(contextId);
        try {
            MemoryFolder memoryFolder = this.initializeFolder(folderId, treeId, userId, contextId, con);
            return memoryFolder;
        }
        finally {
            databaseService.backWritableAfterReading(contextId, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MemoryFolder initializeFolder(String folderId, int treeId, int userId, int contextId, Connection con) throws OXException {
        MemoryFolderImpl memoryFolderImpl;
        if (null == con) {
            return this.initializeFolder(folderId, treeId, userId, contextId);
        }
        MemoryTree memoryTree = this.optTree(treeId);
        if (null == memoryTree) {
            memoryTree = this.getTree(treeId, userId, contextId);
            return memoryTree.getCrud().get(folderId);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT t.parentId, t.name, t.lastModified, t.modifiedBy, s.subscribed, t.sortNum FROM virtualTree AS t LEFT JOIN virtualSubscription AS s ON t.cid = s.cid AND t.tree = s.tree AND t.user = s.user AND t.folderId = s.folderId WHERE t.cid = ? AND t.user = ? AND t.tree = ? AND t.folderId = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setInt(3, treeId);
            stmt.setString(4, folderId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw FolderExceptionErrorMessage.NOT_FOUND.create(folderId, treeId);
            }
            MemoryFolderImpl memoryFolder = new MemoryFolderImpl();
            memoryFolder.setId(folderId);
            int modifiedBy = rs.getInt(4);
            if (rs.wasNull()) {
                memoryFolder.setModifiedBy(-1);
            } else {
                memoryFolder.setModifiedBy(modifiedBy);
            }
            long date = rs.getLong(3);
            if (rs.wasNull()) {
                memoryFolder.setLastModified(null);
            } else {
                memoryFolder.setLastModified(new Date(date));
            }
            memoryFolder.setName(rs.getString(2));
            memoryFolder.setParentId(rs.getString(1));
            int subscribed = rs.getInt(5);
            if (!rs.wasNull()) {
                memoryFolder.setSubscribed(subscribed > 0);
            }
            int sortNum = rs.getInt(6);
            if (!rs.wasNull()) {
                memoryFolder.setSortNum(sortNum);
            }
            MemoryTable.addPermissions(memoryFolder, treeId, userId, contextId, con);
            memoryTree.getCrud().put(memoryFolder);
            memoryFolderImpl = memoryFolder;
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return memoryFolderImpl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addPermissions(MemoryFolderImpl memoryFolder, int treeId, int userId, int contextId, Connection con) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT entity, fp, orp, owp, odp, adminFlag, groupFlag, system FROM virtualPermission WHERE cid = ? AND user = ? AND tree = ? AND folderId = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setInt(3, treeId);
            stmt.setString(4, memoryFolder.getId());
            rs = stmt.executeQuery();
            if (rs.next()) break block7;
            DBUtils.closeSQLStuff(rs, stmt);
            return;
        }
        try {
            ArrayList<MemoryPermission> list = new ArrayList<MemoryPermission>(4);
            do {
                list.add(new MemoryPermission(rs));
            } while (rs.next());
            memoryFolder.setPermissions(list.toArray(new Permission[list.size()]));
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return;
    }

    private static Key keyFor(Session session) {
        return new Key(session.getUserId(), session.getContextId());
    }

    private static Key keyFor(int userId, int contextId) {
        return new Key(userId, contextId);
    }

    private static final class Key {
        private final int cid;
        private final int user;
        private final int hash;

        protected Key(int user, int cid) {
            this.user = user;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + user;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.user == other.user;
        }
    }
}

