/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;

public final class ConsistencyPerformer
extends AbstractPerformer {
    public ConsistencyPerformer(ServerSession session) throws OXException {
        super(session);
    }

    public ConsistencyPerformer(User user, Context context) {
        super(user, context);
    }

    public ConsistencyPerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, folderStorageDiscoverer);
    }

    public ConsistencyPerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
    }

    public void doConsistencyCheck(String treeId) throws OXException {
        FolderStorage[] folderStorages;
        for (FolderStorage folderStorage : folderStorages = this.folderStorageDiscoverer.getFolderStoragesForTreeID(treeId)) {
            boolean started = folderStorage.startTransaction(this.storageParameters, true);
            try {
                folderStorage.checkConsistency(treeId, this.storageParameters);
                if (!started) continue;
                folderStorage.commitTransaction(this.storageParameters);
            }
            catch (OXException e) {
                if (started) {
                    folderStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    folderStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
    }
}

