/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.ContentTypeDiscoveryService;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageComparator;
import com.openexchange.folderstorage.virtual.VirtualFolderStorage;
import com.openexchange.folderstorage.virtual.VirtualFolderType;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentTypeRegistry
implements ContentTypeDiscoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(ContentTypeRegistry.class);
    private static final ContentTypeRegistry instance = new ContentTypeRegistry();
    private final ConcurrentMap<String, Element> registry = new ConcurrentHashMap<String, Element>();

    public static ContentTypeRegistry getInstance() {
        return instance;
    }

    private ContentTypeRegistry() {
    }

    private Element getElementForTreeId(String treeId) {
        return this.getElementForTreeId(treeId, true);
    }

    private Element getElementForTreeId(String treeId, boolean createIfAbsent) {
        Element inst;
        Element element = (Element)this.registry.get(treeId);
        if (null == element && createIfAbsent && null == (element = this.registry.putIfAbsent(treeId, inst = new Element()))) {
            element = inst;
        }
        return element;
    }

    public boolean addContentType(String treeId, ContentType contentType, FolderStorage folderStorage) {
        boolean added;
        ConcurrentMap<ContentType, FolderStorage> types = this.getElementForTreeId(treeId).getConcreteStorages();
        boolean bl = added = null == types.putIfAbsent(contentType, folderStorage);
        if (!added) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("Could not register content type \"");
            sb.append(contentType.getClass().getName());
            sb.append("\" for tree identifier \"").append(treeId).append("\". Duplicate content type detected.");
            LOG.error(sb.toString());
        }
        return added;
    }

    public boolean addGeneralContentType(String treeId, FolderStorage folderStorage) {
        Element element = this.getElementForTreeId(treeId);
        ArrayList<FolderStorage> generalStorages = new ArrayList<FolderStorage>(element.getGeneralStorages());
        generalStorages.add(folderStorage);
        Collections.sort(generalStorages, FolderStorageComparator.getInstance());
        element.replaceGeneralStorages(generalStorages);
        return true;
    }

    public Map<Integer, ContentType> getAvailableContentTypes() {
        ConcurrentMap<ContentType, FolderStorage> concreteStorages = this.getElementForTreeId(FolderStorage.REAL_TREE_ID).getConcreteStorages();
        if (concreteStorages.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, ContentType> ret = new HashMap<Integer, ContentType>(concreteStorages.size());
        for (ContentType contentType : concreteStorages.keySet()) {
            ret.put(contentType.getModule(), contentType);
        }
        return ret;
    }

    public FolderStorage getFolderStorageByContentType(String treeId, ContentType contentType) {
        Element element = this.getElementForTreeId(treeId, false);
        if (null == element) {
            if (VirtualFolderType.getInstance().servesTreeId(treeId)) {
                return VirtualFolderStorage.getInstance();
            }
            return null;
        }
        Queue<FolderStorage> generalStorages = element.getGeneralStorages();
        if (!generalStorages.isEmpty()) {
            return generalStorages.peek();
        }
        ConcurrentMap<ContentType, FolderStorage> types = element.getConcreteStorages();
        if (null == types) {
            return null;
        }
        return (FolderStorage)types.get(contentType);
    }

    @Override
    public ContentType getByString(String contentTypeString) {
        for (Map.Entry entry : this.registry.entrySet()) {
            Queue<FolderStorage> generalStorages = ((Element)entry.getValue()).getGeneralStorages();
            ContentType candidate = null;
            Iterator i$ = generalStorages.iterator();
            while (i$.hasNext()) {
                ContentType[] supportedContentTypes;
                FolderStorage genStorage;
                FolderStorage folderStorage = genStorage = (FolderStorage)i$.next();
                for (ContentType supportedContentType : supportedContentTypes = folderStorage.getSupportedContentTypes()) {
                    if (!((Object)supportedContentType).toString().equals(contentTypeString) || null != candidate && candidate.getPriority() <= supportedContentType.getPriority()) continue;
                    candidate = supportedContentType;
                }
            }
            if (candidate != null) {
                return candidate;
            }
            Set concreteCTs = ((Element)entry.getValue()).getConcreteStorages().keySet();
            for (ContentType contentType : concreteCTs) {
                if (!((Object)contentType).toString().equals(contentTypeString) || null != candidate && candidate.getPriority() <= contentType.getPriority()) continue;
                candidate = contentType;
            }
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public void removeContentType(String treeId, ContentType contentType) {
        Element element = this.getElementForTreeId(treeId, false);
        if (null == element) {
            return;
        }
        element.getConcreteStorages().remove(contentType);
    }

    public void removeGeneralContentType(String treeId, FolderStorage folderStorage) {
        Element element = this.getElementForTreeId(treeId, false);
        if (null == element) {
            return;
        }
        ArrayList<FolderStorage> generalStorages = new ArrayList<FolderStorage>(element.getGeneralStorages());
        generalStorages.remove(folderStorage);
        Collections.sort(generalStorages, FolderStorageComparator.getInstance());
        element.replaceGeneralStorages(generalStorages);
    }

    public void removeTreeContentTypes(String treeId) {
        this.registry.remove(treeId);
    }

    private static final class Element {
        private final ConcurrentMap<ContentType, FolderStorage> concreteStorages = new ConcurrentHashMap<ContentType, FolderStorage>();
        private volatile Queue<FolderStorage> generalStorages = new Java7ConcurrentLinkedQueue();

        public ConcurrentMap<ContentType, FolderStorage> getConcreteStorages() {
            return this.concreteStorages;
        }

        public Queue<FolderStorage> getGeneralStorages() {
            return this.generalStorages;
        }

        public void replaceGeneralStorages(List<FolderStorage> replacement) {
            this.generalStorages = new Java7ConcurrentLinkedQueue(replacement);
        }
    }
}

