/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.DefaultFileStoragePermission;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.WarningsAware;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.filestorage.FileStorageFolderImpl;
import com.openexchange.folderstorage.filestorage.FileStorageFolderStorageServiceRegistry;
import com.openexchange.folderstorage.filestorage.FileStorageFolderType;
import com.openexchange.folderstorage.filestorage.FileStorageId;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.type.FileStorageType;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class FileStorageFolderStorage
implements FolderStorage {
    private static final String PARAM = "file.Access";
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private static final String INFOSTORE = Integer.toString(9);
    private static final String SERVICE_INFOSTORE = "infostore";

    private IDBasedFolderAccess getFolderAccess(StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == folderAccess) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        return folderAccess;
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        return folder;
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        throw new UnsupportedOperationException("FileStorageFolderStorage.getVisibleSubfolders()");
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{FileStorageContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return FileStorageContentType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null != folderAccess) {
            try {
                folderAccess.commit();
            }
            finally {
                storageParameters.putParameter(FileStorageFolderType.getInstance(), PARAM, null);
            }
        }
    }

    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
        fsFolder.setExists(false);
        fsFolder.setParentId(folder.getParentID());
        fsFolder.setName(folder.getName());
        fsFolder.setSubscribed(folder.isSubscribed());
        Session session = storageParameters.getSession();
        if (null == session) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            ArrayList<DefaultFileStoragePermission> fsPermissions = new ArrayList<DefaultFileStoragePermission>(permissions.length);
            for (Permission permission : permissions) {
                DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
                fsPerm.setEntity(permission.getEntity());
                fsPerm.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                fsPerm.setAdmin(permission.isAdmin());
                fsPerm.setGroup(permission.isGroup());
                fsPermissions.add(fsPerm);
            }
            fsFolder.setPermissions(fsPermissions);
        } else if ("".equals(folder.getParentID())) {
            FileStoragePermission[] messagingPermissions = new FileStoragePermission[1];
            DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
            fsPerm.setEntity(session.getUserId());
            fsPerm.setAllPermissions(128, 128, 128, 128);
            fsPerm.setAdmin(true);
            fsPerm.setGroup(false);
            messagingPermissions[0] = fsPerm;
            fsFolder.setPermissions(Arrays.asList(messagingPermissions));
        } else {
            FileStorageFolder parent = folderAccess.getFolder(folder.getParentID());
            List parentPermissions = parent.getPermissions();
            FileStoragePermission[] ffPermissions = new FileStoragePermission[parentPermissions.size()];
            int i = 0;
            for (FileStoragePermission parentPerm : parentPermissions) {
                DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
                fsPerm.setEntity(parentPerm.getEntity());
                fsPerm.setAllPermissions(parentPerm.getFolderPermission(), parentPerm.getReadPermission(), parentPerm.getWritePermission(), parentPerm.getDeletePermission());
                fsPerm.setAdmin(parentPerm.isAdmin());
                fsPerm.setGroup(parentPerm.isGroup());
                ffPermissions[i++] = fsPerm;
            }
            fsFolder.setPermissions(Arrays.asList(ffPermissions));
        }
        String fullName = folderAccess.createFolder((FileStorageFolder)fsFolder);
        folder.setID(fullName);
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        folderAccess.clearFolder(folderId, true);
    }

    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        folderAccess.deleteFolder(folderId, true);
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!(contentType instanceof FileStorageContentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(((Object)contentType).toString());
        }
        return INFOSTORE;
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return FileStorageType.getInstance();
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        if (!folderAccess.exists(folderId)) {
            FolderID folderID = new FolderID(folderId);
            throw FileStorageExceptionCodes.FOLDER_NOT_FOUND.create(new Object[]{folderID.getFolderId(), Integer.valueOf(folderID.getAccountId()), folderID.getService(), storageParameters.getUserId(), storageParameters.getContextId()});
        }
        return false;
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        return 0 == folderAccess.getFolder(folderId).getFileCount();
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
        for (String folderId : folderIds) {
            ret.add(this.getFolder(treeId, folderId, storageType, storageParameters));
        }
        return ret;
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        FileStorageFolder fsFolder = folderAccess.getFolder(folderId);
        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
        FileStorageFolderImpl retval = new FileStorageFolderImpl(fsFolder, storageParameters.getSession(), altNames);
        boolean hasSubfolders = fsFolder.hasSubfolders();
        retval.setTreeID(treeId);
        retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
        return retval;
    }

    @Override
    public FolderType getFolderType() {
        return FileStorageFolderType.getInstance();
    }

    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        Session s = storageParameters.getSession();
        if (null == s) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
        }
        ServerSession session = s instanceof ServerSession ? (ServerSession)s : ServerSessionAdapter.valueOf(s);
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == folderAccess) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        boolean isRealTree = REAL_TREE_ID.equals(treeId);
        if (isRealTree ? PRIVATE_FOLDER_ID.equals(parentId) : INFOSTORE.equals(parentId)) {
            int size;
            ArrayList<FileStorageFolder> rootFolders = new ArrayList<FileStorageFolder>(Arrays.asList(folderAccess.getRootFolders(session.getUser().getLocale())));
            if (isRealTree) {
                Iterator it = rootFolders.iterator();
                while (it.hasNext()) {
                    if (!INFOSTORE.equals(((FileStorageFolder)it.next()).getId())) continue;
                    it.remove();
                }
            }
            if ((size = rootFolders.size()) <= 0) {
                return new SortableId[0];
            }
            ArrayList<FileStorageId> list = new ArrayList<FileStorageId>(size);
            for (int j = 0; j < size; ++j) {
                list.add(new FileStorageId(((FileStorageFolder)rootFolders.get(j)).getId(), j, null));
            }
            return list.toArray(new SortableId[list.size()]);
        }
        List<FileStorageFolder> children = Arrays.asList(folderAccess.getSubfolders(parentId, true));
        Collections.sort(children, new SimpleFileStorageFolderComparator(storageParameters.getUser().getLocale()));
        ArrayList<FileStorageId> list = new ArrayList<FileStorageId>(children.size());
        int size = children.size();
        for (int j = 0; j < size; ++j) {
            FileStorageFolder cur = children.get(j);
            list.add(new FileStorageId(cur.getId(), j, cur.getName()));
        }
        return list.toArray(new SortableId[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(StorageParameters storageParameters) {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null != folderAccess) {
            try {
                folderAccess.rollback();
            }
            catch (Exception exception) {
            }
            finally {
                storageParameters.putParameter(FileStorageFolderType.getInstance(), PARAM, null);
            }
        }
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        if (null == parameters.getSession()) {
            throw FolderExceptionErrorMessage.MISSING_SESSION.create();
        }
        IDBasedFolderAccessFactory factory = (IDBasedFolderAccessFactory)FileStorageFolderStorageServiceRegistry.getServiceRegistry().getService(IDBasedFolderAccessFactory.class);
        if (null == factory) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{IDBasedFolderAccessFactory.class.getName()});
        }
        return parameters.putParameterIfAbsent(FileStorageFolderType.getInstance(), PARAM, factory.createAccess(parameters.getSession()));
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            return false;
        }
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        return folderAccess.exists(folderId);
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<ContentType> supported = new HashSet<ContentType>(Arrays.asList(this.getSupportedContentTypes()));
        for (ContentType includeContentType : includeContentTypes) {
            SortableId[] subfolders;
            if (!supported.contains(includeContentType)) continue;
            for (SortableId sortableId : subfolders = this.getSubfolders(FolderStorage.REAL_TREE_ID, PRIVATE_FOLDER_ID, storageParameters)) {
                ret.add(sortableId.getId());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = this.getFolderAccess(storageParameters);
        DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
        fsFolder.setExists(true);
        fsFolder.setId(folder.getID());
        if (null != folder.getParentID()) {
            fsFolder.setParentId(folder.getParentID());
        }
        if (null != folder.getName()) {
            fsFolder.setName(folder.getName());
        }
        fsFolder.setSubscribed(folder.isSubscribed());
        FileStoragePermission[] fsPermissions = null;
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            fsPermissions = new FileStoragePermission[permissions.length];
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                DefaultFileStoragePermission dmp = DefaultFileStoragePermission.newInstance();
                dmp.setEntity(permission.getEntity());
                dmp.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                dmp.setAdmin(permission.isAdmin());
                dmp.setGroup(permission.isGroup());
                fsPermissions[i] = dmp;
            }
            fsFolder.setPermissions(Arrays.asList(fsPermissions));
        }
        FileStorageFolder storageVersion = folderAccess.getFolder(folder.getID());
        String oldParent = storageVersion.getParentId();
        String oldName = storageVersion.getName();
        String newName = fsFolder.getName();
        boolean movePerformed = false;
        String newParent = fsFolder.getParentId();
        if (newParent != null) {
            FolderID newParentID = new FolderID(newParent);
            FolderID folderID = new FolderID(folder.getID());
            if (folderID.getAccountId().equals(newParentID.getAccountId())) {
                if (!newParent.equals(oldParent)) {
                    boolean rename = null != newName && !newName.equals(oldName);
                    this.check4DuplicateFolder(folderAccess, newParent, rename ? newName : oldName);
                    String movedFolder = folderAccess.moveFolder(fsFolder.getId(), newParent);
                    if (rename) {
                        movedFolder = folderAccess.renameFolder(movedFolder, newName);
                    }
                    folder.setID(movedFolder);
                    fsFolder.setId(movedFolder);
                    movePerformed = true;
                }
            } else {
                FileStorageFolder p = folderAccess.getFolder(newParent);
                FileStoragePermission ownPermission = p.getOwnPermission();
                if (ownPermission.getFolderPermission() < 8) {
                    throw FileStorageExceptionCodes.NO_CREATE_ACCESS.create(new Object[]{newParent});
                }
                this.check4DuplicateFolder(folderAccess, newParent, null == newName ? oldName : newName);
                String destFullname = FileStorageFolderStorage.fullCopy(folderAccess, folder.getID(), newParent, storageParameters.getUserId(), p.getCapabilities().contains("permissions"));
                folderAccess.deleteFolder(folder.getID(), true);
                String updatedId = folderAccess.updateFolder(destFullname, (FileStorageFolder)fsFolder);
                fsFolder.setId(updatedId);
            }
        }
        if (!movePerformed && newName != null && !newName.equals(oldName)) {
            String updatedId = folderAccess.renameFolder(fsFolder.getId(), newName);
            folder.setID(updatedId);
            fsFolder.setId(updatedId);
        }
        folderAccess.updateFolder(fsFolder.getId(), (FileStorageFolder)fsFolder);
        if (null != fsPermissions && StorageParametersUtility.isHandDownPermissions(storageParameters)) {
            FileStorageFolderStorage.handDown(fsFolder.getId(), fsPermissions, folderAccess);
        }
    }

    private static void handDown(String parentId, FileStoragePermission[] fsPermissions, IDBasedFolderAccess folderAccess) throws OXException {
        FileStorageFolder[] subfolders;
        for (FileStorageFolder subfolder : subfolders = folderAccess.getSubfolders(parentId, true)) {
            DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
            fsFolder.setExists(true);
            String id = subfolder.getId();
            fsFolder.setId(id);
            fsFolder.setPermissions(Arrays.asList(fsPermissions));
            folderAccess.updateFolder(id, (FileStorageFolder)fsFolder);
            FileStorageFolderStorage.handDown(id, fsPermissions, folderAccess);
        }
    }

    private void check4DuplicateFolder(IDBasedFolderAccess folderAccess, String parentId, String name2check) throws OXException {
        FileStorageFolder[] subfolders;
        for (FileStorageFolder subfolder : subfolders = folderAccess.getSubfolders(parentId, true)) {
            if (!name2check.equals(subfolder.getName())) continue;
            throw FileStorageExceptionCodes.DUPLICATE_FOLDER.create(new Object[]{name2check, parentId});
        }
    }

    private static String fullCopy(IDBasedFolderAccess folderAccess, String srcFullname, String destParent, int user, boolean hasPermissions) throws OXException {
        FileStorageFolder[] tmp;
        FileStorageFolder source = folderAccess.getFolder(srcFullname);
        DefaultFileStorageFolder mfd = new DefaultFileStorageFolder();
        mfd.setName(source.getName());
        mfd.setParentId(destParent);
        mfd.setSubscribed(source.isSubscribed());
        if (hasPermissions) {
            List perms = source.getPermissions();
            for (FileStoragePermission perm : perms) {
                mfd.addPermission((FileStoragePermission)perm.clone());
            }
        }
        String destFullname = folderAccess.createFolder((FileStorageFolder)mfd);
        for (FileStorageFolder element : tmp = folderAccess.getSubfolders(srcFullname, true)) {
            FileStorageFolderStorage.fullCopy(folderAccess, element.getId(), destFullname, user, hasPermissions);
        }
        return destFullname;
    }

    private static void addWarnings(StorageParameters storageParameters, WarningsAware warningsAware) {
        List list = warningsAware.getAndFlushWarnings();
        if (null != list && !list.isEmpty()) {
            for (OXException warning : list) {
                storageParameters.addWarning(warning);
            }
        }
    }

    private static final class FileStorageFolderComparator
    implements Comparator<FileStorageFolder> {
        private final Map<String, Integer> indexMap;
        private final Collator collator;
        private final Integer na;

        FileStorageFolderComparator(String[] names, Locale locale) {
            this.indexMap = new HashMap<String, Integer>(names.length);
            for (int i = 0; i < names.length; ++i) {
                this.indexMap.put(names[i], i);
            }
            this.na = names.length;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        private Integer getNumberOf(String name) {
            Integer ret = this.indexMap.get(name);
            if (null == ret) {
                return this.na;
            }
            return ret;
        }

        @Override
        public int compare(FileStorageFolder o1, FileStorageFolder o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    return this.getNumberOf(o1.getId()).compareTo(this.getNumberOf(o2.getId()));
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class SimpleFileStorageFolderComparator
    implements Comparator<FileStorageFolder> {
        private final Collator collator;

        SimpleFileStorageFolderComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(FileStorageFolder o1, FileStorageFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }

    private static final class FileStorageAccountComparator
    implements Comparator<FileStorageAccount> {
        private final Collator collator;

        FileStorageAccountComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(FileStorageAccount o1, FileStorageAccount o2) {
            return this.collator.compare(o1.getDisplayName(), o2.getDisplayName());
        }
    }
}

