/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.i18n.tools.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SystemRootFolder {
    private static final boolean preload = true;
    private static final ConcurrentMap<Locale, List<String[]>> CACHED_SUBFOLDERS = new ConcurrentHashMap<Locale, List<String[]>>(16);

    private SystemRootFolder() {
    }

    public static DatabaseFolder getSystemRootFolder() {
        FolderObject fo = FolderObject.createVirtualFolderObject(0, "root", 5, true, 5);
        DatabaseFolder retval = new DatabaseFolder(fo);
        ArrayList<String> list = new ArrayList<String>(4);
        list.add(String.valueOf(1));
        list.add(String.valueOf(2));
        list.add(String.valueOf(3));
        list.add(String.valueOf(9));
        retval.setSubfolderIDs(list.toArray(new String[list.size()]));
        return retval;
    }

    public static List<String[]> getSystemRootFolderSubfolder(Locale locale) {
        ArrayList<String[]> list = (ArrayList<String[]>)CACHED_SUBFOLDERS.get(locale);
        if (null == list) {
            StringHelper sh = StringHelper.valueOf(locale);
            ArrayList<String[]> newList = new ArrayList<String[]>(4);
            newList.add(new String[]{String.valueOf(1), sh.getString("Private folders")});
            newList.add(new String[]{String.valueOf(2), sh.getString("Public folders")});
            newList.add(new String[]{String.valueOf(3), sh.getString("Shared folders")});
            newList.add(new String[]{String.valueOf(9), sh.getString("Infostore")});
            list = CACHED_SUBFOLDERS.putIfAbsent(locale, newList);
            if (null == list) {
                list = newList;
            }
        }
        return list;
    }
}

