/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.database.AltNameLocalizedDatabaseFolder;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.folderstorage.database.getfolder.SystemInfostoreFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPrivateFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPublicFolder;
import com.openexchange.folderstorage.database.getfolder.SystemSharedFolder;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderLoader;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public final class DatabaseFolderConverter {
    private static final TIntObjectMap<FolderConverter> SYSTEM_CONVERTERS;
    private static final TIntObjectMap<FolderConverter> CONVERTERS;
    private static final String DEFAULT_ID = "0";
    private static volatile Boolean preferDisplayName;

    private DatabaseFolderConverter() {
    }

    private static int getContactCollectorFolder(Session session, Connection con) throws OXException {
        int contextId = session.getContextId();
        int userId = session.getUserId();
        String key = "__ccf#";
        Integer ret = (Integer)session.getParameter("__ccf#");
        if (null == ret) {
            Integer folderId = ServerUserSetting.getInstance(con).getContactCollectionFolder(contextId, userId);
            folderId = null == folderId ? Integer.valueOf(-1) : folderId;
            session.setParameter("__ccf#", (Object)folderId);
            ret = folderId;
        }
        return ret;
    }

    private static int getPublishedMailAttachmentsFolder(Session session) {
        if (null == session) {
            return -1;
        }
        Integer i = (Integer)session.getParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID());
        return null == i ? -1 : i;
    }

    public static FileStorageAccount getDefaultFileStorageAccess(Session session) throws OXException {
        FileStorageAccountManagerLookupService lookupService = ServerServiceRegistry.getInstance().getService(FileStorageAccountManagerLookupService.class);
        if (null == lookupService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
        }
        FileStorageAccountManager defaultAccountManager = lookupService.getAccountManager(DEFAULT_ID, session);
        if (null != defaultAccountManager) {
            return defaultAccountManager.getAccount(DEFAULT_ID, session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean preferDisplayName() {
        Boolean tmp = preferDisplayName;
        if (null != tmp) return tmp;
        Class<DatabaseFolderConverter> clazz = DatabaseFolderConverter.class;
        synchronized (DatabaseFolderConverter.class) {
            tmp = preferDisplayName;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            preferDisplayName = tmp = null == service ? Boolean.FALSE : Boolean.valueOf(service.getBoolProperty("com.openexchange.folderstorage.database.preferDisplayName", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static DatabaseFolder convert(FolderObject fo, User user, UserPermissionBits userPermissionBits, Context ctx, Session session, boolean altNames, Connection con) throws OXException {
        try {
            DatabaseFolder retval;
            int folderId = fo.getObjectID();
            if (folderId < 20) {
                if (3 == folderId) {
                    return SystemSharedFolder.getSystemSharedFolder(fo, user, userPermissionBits, ctx, con);
                }
                FolderConverter folderConverter = (FolderConverter)SYSTEM_CONVERTERS.get(folderId);
                if (null != folderConverter) {
                    FileStorageAccount defaultAccount;
                    DatabaseFolder databaseFolder = folderConverter.convert(fo, altNames);
                    if (9 == folderId && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session))) {
                        databaseFolder.setName(defaultAccount.getDisplayName());
                    }
                    return databaseFolder;
                }
                folderConverter = (FolderConverter)CONVERTERS.get(folderId);
                if (null != folderConverter) {
                    DatabaseFolder databaseFolder = folderConverter.convert(fo, altNames);
                    return DatabaseFolderConverter.handleDatabaseFolder(databaseFolder, folderId, fo, session, user, userPermissionBits, ctx, con);
                }
            }
            if (fo.isDefaultFolder()) {
                int module = fo.getModule();
                if (module == 1) {
                    retval = new LocalizedDatabaseFolder(fo);
                    retval.setName("Tasks");
                } else if (module == 3) {
                    retval = new LocalizedDatabaseFolder(fo);
                    retval.setName("Contacts");
                } else if (module == 2) {
                    retval = new LocalizedDatabaseFolder(fo);
                    retval.setName("Calendar");
                } else if (module == 8) {
                    if (DatabaseFolderConverter.preferDisplayName()) {
                        int ownerId = fo.getCreatedBy();
                        if (user.getId() == ownerId) {
                            retval = new LocalizedDatabaseFolder(fo);
                            retval.setName(user.getDisplayName());
                        } else {
                            DatabaseFolder tmp = null;
                            try {
                                User owner = UserStorage.getInstance().getUser(ownerId, ctx);
                                tmp = new LocalizedDatabaseFolder(fo);
                                tmp.setName(owner.getDisplayName());
                            }
                            catch (Exception ignore) {
                                tmp = new DatabaseFolder(fo);
                            }
                            retval = tmp;
                        }
                    } else {
                        retval = new DatabaseFolder(fo);
                    }
                } else {
                    retval = new DatabaseFolder(fo);
                }
            } else if (folderId == DatabaseFolderConverter.getContactCollectorFolder(session, con)) {
                retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Collected addresses");
                retval.setDefault(true);
                retval.setCacheable(true);
                retval.setGlobal(false);
            } else if (folderId == DatabaseFolderConverter.getPublishedMailAttachmentsFolder(session)) {
                retval = new LocalizedDatabaseFolder(fo);
                retval.setName("E-Mail attachments");
            } else {
                retval = new DatabaseFolder(fo);
                boolean checkIfVirtuallyReachable = false;
            }
            return DatabaseFolderConverter.handleDatabaseFolder(retval, folderId, fo, session, user, userPermissionBits, ctx, con);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static DatabaseFolder handleDatabaseFolder(DatabaseFolder databaseFolder, int folderId, FolderObject fo, Session session, User user, UserPermissionBits userPerm, Context ctx, Connection con) throws OXException, SQLException {
        int userId = user.getId();
        if (1 == fo.getType() && userId != databaseFolder.getCreatedBy()) {
            databaseFolder.setType(SharedType.getInstance());
            databaseFolder.setGlobal(false);
            databaseFolder.setCacheable(OXFolderProperties.isEnableSharedFolderCaching());
            databaseFolder.setDefault(false);
            TIntList visibleSubfolders = OXFolderIteratorSQL.getVisibleSubfolders(folderId, userId, user.getGroups(), userPerm.getAccessibleModules(), ctx, con);
            if (visibleSubfolders.isEmpty()) {
                databaseFolder.setSubfolderIDs(new String[0]);
                databaseFolder.setSubscribedSubfolders(false);
            } else {
                String[] tmp = new String[visibleSubfolders.size()];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = Integer.toString(visibleSubfolders.get(i), 10);
                }
                databaseFolder.setSubfolderIDs(tmp);
                databaseFolder.setSubscribedSubfolders(true);
            }
            int parent = fo.getParentFolderID();
            if (1 == parent || !OXFolderIteratorSQL.isVisibleFolder(parent, userId, user.getGroups(), userPerm.getAccessibleModules(), ctx, con)) {
                databaseFolder.setParentID(new StringAllocator(8).append("u:").append(databaseFolder.getCreatedBy()).toString());
            } else {
                databaseFolder.setParentID(Integer.toString(parent, 10));
            }
        } else if (10 == folderId) {
            FileStorageAccount defaultAccount;
            boolean setChildren = true;
            if (!InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session))) {
                databaseFolder.setSubfolderIDs(null);
                setChildren = false;
            }
            if (setChildren) {
                TIntList subfolders = OXFolderIteratorSQL.getVisibleSubfolders(folderId, userId, user.getGroups(), userPerm.getAccessibleModules(), ctx, null);
                if (subfolders.isEmpty()) {
                    databaseFolder.setSubfolderIDs(new String[0]);
                    databaseFolder.setSubscribedSubfolders(false);
                } else {
                    int len = subfolders.size();
                    String[] arr = new String[len];
                    for (int i = 0; i < len; ++i) {
                        arr[i] = Integer.toString(subfolders.get(i), 10);
                    }
                    databaseFolder.setSubfolderIDs(arr);
                    databaseFolder.setSubscribedSubfolders(true);
                }
            }
            databaseFolder.setCacheable(true);
            databaseFolder.setGlobal(false);
        } else {
            FileStorageAccount defaultAccount;
            boolean setChildren = true;
            if (15 == folderId && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session))) {
                databaseFolder.setSubfolderIDs(null);
                databaseFolder.setCacheable(true);
                databaseFolder.setGlobal(false);
                setChildren = false;
            }
            if (setChildren) {
                TIntList subfolderIds;
                if (fo.containsSubfolderIds()) {
                    subfolderIds = fo.getSubfolderIds();
                    if (subfolderIds.isEmpty()) {
                        databaseFolder.setSubfolderIDs(new String[0]);
                        databaseFolder.setSubscribedSubfolders(false);
                    } else {
                        ArrayList<String> tmp = new ArrayList<String>(subfolderIds.size());
                        for (Integer id : subfolderIds) {
                            tmp.add(Integer.toString(id, 10));
                        }
                        databaseFolder.setSubfolderIDs(tmp.toArray(new String[tmp.size()]));
                        databaseFolder.setSubscribedSubfolders(true);
                    }
                } else {
                    subfolderIds = OXFolderLoader.getSubfolderInts(folderId, ctx, con);
                    if (subfolderIds.isEmpty()) {
                        databaseFolder.setSubfolderIDs(new String[0]);
                        databaseFolder.setSubscribedSubfolders(false);
                    } else {
                        int len = subfolderIds.size();
                        String[] arr = new String[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = Integer.toString(subfolderIds.get(i), 10);
                        }
                        databaseFolder.setSubfolderIDs(arr);
                        databaseFolder.setSubscribedSubfolders(true);
                    }
                }
            }
        }
        databaseFolder.setSupportedCapabilities(FileStorageFolder.ALL_CAPABILITIES);
        return databaseFolder;
    }

    private static int getPossibleVirtualParent(FolderObject fo) {
        switch (fo.getModule()) {
            case 1: {
                return 11;
            }
            case 3: {
                return 13;
            }
            case 2: {
                return 12;
            }
            case 8: {
                return 14;
            }
        }
        return 0;
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(4);
        m.put(2, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                return SystemPublicFolder.getSystemPublicFolder(fo);
            }
        });
        m.put(9, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                return SystemInfostoreFolder.getSystemInfostoreFolder(fo, altNames);
            }
        });
        m.put(1, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                return SystemPrivateFolder.getSystemPrivateFolder(fo);
            }
        });
        SYSTEM_CONVERTERS = m;
        m = new TIntObjectHashMap(4);
        m.put(15, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                AltNameLocalizedDatabaseFolder retval = new AltNameLocalizedDatabaseFolder(fo, "Public files");
                retval.setName(altNames ? "Public files" : "Public infostore");
                return retval;
            }
        });
        m.put(10, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                AltNameLocalizedDatabaseFolder retval = new AltNameLocalizedDatabaseFolder(fo, "Shared files");
                retval.setName(altNames ? "Shared files" : "Userstore");
                return retval;
            }
        });
        m.put(6, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Global address book");
                retval.setParentID(FolderStorage.PUBLIC_ID);
                return retval;
            }
        });
        m.put(5, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo, boolean altNames) throws OXException {
                LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Shared address book");
                retval.setParentID(FolderStorage.PUBLIC_ID);
                return retval;
            }
        });
        CONVERTERS = m;
    }

    private static interface FolderConverter {
        public DatabaseFolder convert(FolderObject var1, boolean var2) throws OXException;
    }
}

