/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.AltNameAwareFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class AltNameLocalizedDatabaseFolder
extends LocalizedDatabaseFolder
implements AltNameAwareFolder {
    private static final long serialVersionUID = 3834568343115931304L;
    private final String altName;

    public AltNameLocalizedDatabaseFolder(FolderObject folderObject, String altName) {
        this(folderObject, true, altName);
    }

    public AltNameLocalizedDatabaseFolder(FolderObject folderObject, boolean cacheable, String altName) {
        super(folderObject, cacheable);
        this.localizedNames = new NonBlockingHashMap(8);
        this.altName = altName;
    }

    @Override
    public Object clone() {
        AltNameLocalizedDatabaseFolder clone = (AltNameLocalizedDatabaseFolder)super.clone();
        ConcurrentMap thisMap = this.localizedNames;
        if (null == this.localizedNames) {
            clone.localizedNames = null;
        } else {
            NonBlockingHashMap cloneMap = new NonBlockingHashMap(thisMap.size());
            for (Map.Entry entry : thisMap.entrySet()) {
                cloneMap.put(entry.getKey(), entry.getValue());
            }
            clone.localizedNames = cloneMap;
        }
        return clone;
    }

    @Override
    public String getLocalizedName(Locale locale, boolean altName) {
        if (!altName) {
            return this.getLocalizedName(locale);
        }
        String toTranslate = this.altName;
        if (null == toTranslate) {
            return this.getLocalizedName(locale);
        }
        return this.translationFor(toTranslate, locale);
    }

    @Override
    public boolean supportsAltName() {
        return true;
    }
}

