/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.memory;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.mailaccount.Tools;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderMapManagement {
    private static final Logger LOG = LoggerFactory.getLogger(FolderMapManagement.class);
    private static final FolderMapManagement INSTANCE = new FolderMapManagement();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, FolderMap>> map = new ConcurrentLinkedHashMap.Builder().initialCapacity(64).maximumWeightedCapacity(5000L).weigher(Weighers.entrySingleton()).build();

    public static FolderMapManagement getInstance() {
        return INSTANCE;
    }

    private FolderMapManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(int contextId) {
        this.map.remove(contextId);
        LOG.debug("Cleaned user-sensitive folder cache for context {}", (Object)contextId);
    }

    public void dropFor(Session session) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null != contextMap) {
            contextMap.remove(session.getUserId());
        }
        LOG.debug("Cleaned user-sensitive folder cache for user {} in context {}", (Object)session.getUserId(), (Object)session.getContextId());
    }

    public void dropFor(int userId, int contextId) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null != contextMap) {
            contextMap.remove(userId);
        }
        LOG.debug("Cleaned user-sensitive folder cache for user {} in context {}", (Object)userId, (Object)contextId);
    }

    public FolderMap getFor(Session session) {
        FolderMap newFolderMap;
        Integer us;
        FolderMap folderMap;
        NonBlockingHashMap newMap;
        Integer cid = session.getContextId();
        NonBlockingHashMap contextMap = (NonBlockingHashMap)this.map.get(cid);
        if (null == contextMap && null == (contextMap = this.map.putIfAbsent(cid, (ConcurrentMap<Integer, FolderMap>)(newMap = new NonBlockingHashMap(256))))) {
            contextMap = newMap;
        }
        if (null == (folderMap = (FolderMap)contextMap.get(us = Integer.valueOf(session.getUserId()))) && null == (folderMap = contextMap.putIfAbsent(us, newFolderMap = new FolderMap(1024, 300, TimeUnit.SECONDS, session.getUserId(), session.getContextId())))) {
            folderMap = newFolderMap;
        }
        return folderMap;
    }

    public FolderMap optFor(Session session) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(session.getContextId());
        if (null == contextMap) {
            return null;
        }
        return (FolderMap)contextMap.get(session.getUserId());
    }

    public FolderMap optFor(int userId, int contextId) {
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return null;
        }
        return (FolderMap)contextMap.get(userId);
    }

    public void dropFor(String folderId, String treeId, int optUser, int contextId) {
        this.dropFor(folderId, treeId, optUser, contextId, null);
    }

    public void dropFor(String folderId, String treeId, int optUser, int contextId, Session optSession) {
        if (null == folderId || null == treeId) {
            return;
        }
        ConcurrentMap contextMap = (ConcurrentMap)this.map.get(contextId);
        if (null == contextMap) {
            return;
        }
        if (optUser > 0 && Tools.getUnsignedInteger(folderId) < 0) {
            FolderMap folderMap = (FolderMap)contextMap.get(optUser);
            if (null != folderMap) {
                folderMap.remove(folderId, treeId, optSession);
            }
        } else {
            for (FolderMap folderMap : contextMap.values()) {
                if (null == optSession) {
                    folderMap.remove(folderId, treeId);
                    continue;
                }
                folderMap.remove(folderId, treeId, optSession);
            }
        }
    }
}

