/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageComparator;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheContentTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CacheContentTypeRegistry.class);
    private static final CacheContentTypeRegistry instance = new CacheContentTypeRegistry();
    private final ConcurrentMap<String, Element> registry = new ConcurrentHashMap<String, Element>();

    public static CacheContentTypeRegistry getInstance() {
        return instance;
    }

    private CacheContentTypeRegistry() {
    }

    private Element getElementForTreeId(String treeId) {
        return this.getElementForTreeId(treeId, true);
    }

    private Element getElementForTreeId(String treeId, boolean createIfAbsent) {
        Element inst;
        Element element = (Element)this.registry.get(treeId);
        if (null == element && createIfAbsent && null == (element = this.registry.putIfAbsent(treeId, inst = new Element()))) {
            element = inst;
        }
        return element;
    }

    public boolean addContentType(String treeId, ContentType contentType, FolderStorage folderStorage) {
        boolean added;
        Element element = this.getElementForTreeId(treeId);
        ConcurrentMap<ContentType, FolderStorage> types = element.getConcreteStorages();
        boolean bl = added = null == types.putIfAbsent(contentType, folderStorage);
        if (!added) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("Could not register content type \"");
            sb.append(contentType.getClass().getName());
            sb.append("\" for tree identifier \"").append(treeId).append("\". Duplicate content type detected.");
            LOG.error(sb.toString());
        }
        return added;
    }

    public boolean addGeneralContentType(String treeId, FolderStorage folderStorage) {
        Element element = this.getElementForTreeId(treeId);
        ArrayList<FolderStorage> generalStorages = new ArrayList<FolderStorage>(element.getGeneralStorages());
        generalStorages.add(folderStorage);
        Collections.sort(generalStorages, FolderStorageComparator.getInstance());
        element.replaceGeneralStorages(generalStorages);
        return true;
    }

    public FolderStorage getFolderStorageByContentType(String treeId, ContentType contentType) {
        Element element = this.getElementForTreeId(treeId, false);
        if (null == element) {
            return null;
        }
        Queue<FolderStorage> generalStorages = element.getGeneralStorages();
        if (!generalStorages.isEmpty()) {
            return generalStorages.peek();
        }
        ConcurrentMap<ContentType, FolderStorage> types = element.getConcreteStorages();
        if (null == types) {
            return null;
        }
        return (FolderStorage)types.get(contentType);
    }

    public void removeContentType(String treeId, ContentType contentType) {
        Element element = this.getElementForTreeId(treeId, false);
        if (null == element) {
            return;
        }
        element.getConcreteStorages().remove(contentType);
    }

    public void removeGeneralContentType(String treeId, FolderStorage folderStorage) {
        Element element = this.getElementForTreeId(treeId, false);
        if (null == element) {
            return;
        }
        element.removeAndSortGeneralStorages(folderStorage, FolderStorageComparator.getInstance());
    }

    public void removeTreeContentTypes(String treeId) {
        this.registry.remove(treeId);
    }

    private static final class Element {
        private final ConcurrentMap<ContentType, FolderStorage> concreteStorages = new ConcurrentHashMap<ContentType, FolderStorage>();
        private volatile Queue<FolderStorage> generalStorages = new Java7ConcurrentLinkedQueue();

        public ConcurrentMap<ContentType, FolderStorage> getConcreteStorages() {
            return this.concreteStorages;
        }

        public Queue<FolderStorage> getGeneralStorages() {
            return this.generalStorages;
        }

        public void replaceGeneralStorages(List<FolderStorage> replacement) {
            this.generalStorages = new Java7ConcurrentLinkedQueue(replacement);
        }

        public void removeAndSortGeneralStorages(FolderStorage toRemove, Comparator<FolderStorage> comparator) {
            ArrayList<FolderStorage> sortMe = new ArrayList<FolderStorage>(this.generalStorages);
            sortMe.remove(toRemove);
            Collections.sort(sortMe, comparator);
            this.generalStorages = new Java7ConcurrentLinkedQueue(sortMe);
        }
    }
}

