/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.databaseold;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.ServiceExceptionCode;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Database {
    private static final Logger LOG = LoggerFactory.getLogger(Database.class);
    private static volatile DatabaseService databaseService;

    private Database() {
    }

    public static void setDatabaseService(DatabaseService databaseService) {
        Database.databaseService = databaseService;
    }

    public static DatabaseService getDatabaseService() throws OXException {
        DatabaseService databaseService = Database.databaseService;
        if (null == databaseService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        return databaseService;
    }

    public static int resolvePool(int contextId, boolean write) throws OXException {
        return Database.getDatabaseService().getWritablePool(contextId);
    }

    public static String getSchema(int contextId) throws OXException {
        return Database.getDatabaseService().getSchemaName(contextId);
    }

    public static Connection get(boolean write) throws OXException {
        return write ? Database.getDatabaseService().getWritable() : Database.getDatabaseService().getReadOnly();
    }

    public static Connection get(Context ctx, boolean write) throws OXException {
        return write ? Database.getDatabaseService().getWritable(ctx) : Database.getDatabaseService().getReadOnly(ctx);
    }

    public static Connection get(int contextId, boolean write) throws OXException {
        return write ? Database.getDatabaseService().getWritable(contextId) : Database.getDatabaseService().getReadOnly(contextId);
    }

    public static Connection getNoTimeout(int contextId, boolean write) throws OXException {
        return Database.getDatabaseService().getForUpdateTask(contextId);
    }

    public static Connection get(int poolId, String schema) throws OXException {
        return Database.getDatabaseService().get(poolId, schema);
    }

    public static void back(boolean write, Connection con) {
        try {
            if (write) {
                Database.getDatabaseService().backWritable(con);
            } else {
                Database.getDatabaseService().backReadOnly(con);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void back(Context ctx, boolean write, Connection con) {
        try {
            if (write) {
                Database.getDatabaseService().backWritable(ctx, con);
            } else {
                Database.getDatabaseService().backReadOnly(ctx, con);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void backAfterReading(Context ctx, Connection con) {
        try {
            Database.getDatabaseService().backWritableAfterReading(ctx, con);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void back(int contextId, boolean write, Connection con) {
        try {
            if (write) {
                Database.getDatabaseService().backWritable(contextId, con);
            } else {
                Database.getDatabaseService().backReadOnly(contextId, con);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void backAfterReading(int contextId, Connection con) {
        try {
            Database.getDatabaseService().backWritableAfterReading(contextId, con);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void backNoTimeout(int contextId, boolean write, Connection con) {
        try {
            if (write) {
                Database.getDatabaseService().backForUpdateTask(contextId, con);
            } else {
                Database.getDatabaseService().backForUpdateTaskAfterReading(contextId, con);
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void back(int poolId, Connection con) {
        try {
            Database.getDatabaseService().back(poolId, con);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static Connection getNoTimeout(int poolId, String schema) throws OXException {
        return Database.getDatabaseService().getNoTimeout(poolId, schema);
    }

    public static void backNoTimeoout(int poolId, Connection con) {
        try {
            Database.getDatabaseService().backNoTimeoout(poolId, con);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public static void reset(int contextId) throws OXException {
        Database.getDatabaseService().invalidate(contextId);
    }

    public static int[] getContextsInSameSchema(int contextId) throws OXException {
        return Database.getDatabaseService().getContextsInSameSchema(contextId);
    }

    public static int getServerId() throws OXException {
        return Database.getDatabaseService().getServerId();
    }

    public static String getServerName() throws OXException {
        return Database.getDatabaseService().getServerName();
    }
}

