/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage.internal;

import com.openexchange.contact.ContactFieldOperand;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.contact.Search;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.Operand;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ColumnOperand;
import com.openexchange.search.internal.operands.ConstantOperand;

public class SearchAdapter {
    private final SearchTerm<?> term;
    private static final CompositeSearchTerm HAS_EMAIL_TERM;

    public SearchAdapter(ContactSearchObject contactSearch) throws OXException {
        this.term = null != contactSearch.getPattern() ? this.parseSearchTerm(contactSearch) : this.parseSearchTermAlternative(contactSearch);
    }

    public SearchTerm<?> getSearchTerm() {
        return this.term;
    }

    private SearchTerm<?> parseSearchTerm(ContactSearchObject contactSearch) throws OXException {
        CompositeSearchTerm foldersTerm;
        SearchTerm<Operand<?>> searchTerm;
        String pattern = contactSearch.getPattern();
        SingleSearchTerm singleSearchTerm = searchTerm = contactSearch.isStartLetter() ? SearchAdapter.getStartLetterTerm(pattern) : null;
        if (null == searchTerm || null == searchTerm.getOperands() || 0 == searchTerm.getOperands().length) {
            searchTerm = SearchAdapter.getSearchTerm(ContactField.DISPLAY_NAME, pattern, true, true);
        }
        CompositeSearchTerm compositeSearchTerm = foldersTerm = contactSearch.hasFolders() ? SearchAdapter.parseFoldersTerm(contactSearch.getFolders()) : null;
        if (null != foldersTerm && null != foldersTerm.getOperands() && 0 < foldersTerm.getOperands().length) {
            searchTerm = null == searchTerm ? foldersTerm : SearchAdapter.getCompositeTerm(foldersTerm, searchTerm);
        }
        return searchTerm;
    }

    private SearchTerm<?> parseSearchTermAlternative(ContactSearchObject contactSearch) throws OXException {
        SearchTerm<?> foldersTerm;
        boolean emailAutoComplete = contactSearch.isEmailAutoComplete();
        boolean orSearch = emailAutoComplete || contactSearch.isOrSearch();
        CompositeSearchTerm searchTerm = new CompositeSearchTerm(orSearch ? CompositeSearchTerm.CompositeOperation.OR : CompositeSearchTerm.CompositeOperation.AND);
        if (null != contactSearch.getSurname()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.SUR_NAME, contactSearch.getSurname(), false == orSearch, true));
        }
        if (null != contactSearch.getGivenName()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.GIVEN_NAME, contactSearch.getGivenName(), false == orSearch, true));
        }
        if (null != contactSearch.getDisplayName()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.DISPLAY_NAME, contactSearch.getDisplayName(), false == orSearch, true));
        }
        if (null != contactSearch.getEmail1()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.EMAIL1, contactSearch.getEmail1(), false == orSearch, true));
        }
        if (null != contactSearch.getEmail2()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.EMAIL2, contactSearch.getEmail2(), false == orSearch, true));
        }
        if (null != contactSearch.getEmail3()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.EMAIL3, contactSearch.getEmail3(), false == orSearch, true));
        }
        if (null != contactSearch.getCompany()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.COMPANY, contactSearch.getCompany(), false == orSearch, true));
        }
        if (null != contactSearch.getStreetBusiness()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.STREET_BUSINESS, contactSearch.getStreetBusiness(), false == orSearch, true));
        }
        if (null != contactSearch.getCityBusiness()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.CITY_BUSINESS, contactSearch.getCityBusiness(), false == orSearch, true));
        }
        if (null != contactSearch.getDepartment()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.DEPARTMENT, contactSearch.getDepartment(), false == orSearch, true));
        }
        if (null != contactSearch.getCatgories()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.CATEGORIES, contactSearch.getCatgories(), false == orSearch, true));
        }
        if (null != contactSearch.getYomiLastName()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.YOMI_LAST_NAME, contactSearch.getYomiLastName(), false == orSearch, true));
        }
        if (null != contactSearch.getYomiFirstName()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.YOMI_FIRST_NAME, contactSearch.getYomiFirstName(), false == orSearch, true));
        }
        if (null != contactSearch.getYomiCompany()) {
            searchTerm.addSearchTerm(SearchAdapter.getSearchTerm(ContactField.YOMI_COMPANY, contactSearch.getYomiCompany(), false == orSearch, true));
        }
        if (emailAutoComplete) {
            searchTerm = SearchAdapter.getCompositeTerm(searchTerm, HAS_EMAIL_TERM);
        }
        SearchTerm<?> searchTerm2 = foldersTerm = contactSearch.hasFolders() ? SearchAdapter.parseFoldersTerm(contactSearch.getFolders()) : null;
        if (null != foldersTerm && null != foldersTerm.getOperands() && 0 < foldersTerm.getOperands().length) {
            searchTerm = SearchAdapter.getCompositeTerm(foldersTerm, searchTerm);
        }
        return searchTerm;
    }

    private static CompositeSearchTerm getCompositeTerm(SearchTerm<?> term1, SearchTerm<?> term2) {
        CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
        andTerm.addSearchTerm(term1);
        andTerm.addSearchTerm(term2);
        return andTerm;
    }

    private static SearchTerm<?> parseFoldersTerm(int[] folders2) throws OXException {
        return SearchAdapter.getFoldersTerm(folders2);
    }

    private static SearchTerm<?> getFoldersTerm(int[] folderIDs) {
        if (null == folderIDs || 0 == folderIDs.length) {
            return null;
        }
        if (1 == folderIDs.length) {
            return SearchAdapter.getFolderTerm(folderIDs[0]);
        }
        CompositeSearchTerm orTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
        for (int folderID : folderIDs) {
            orTerm.addSearchTerm(SearchAdapter.getFolderTerm(folderID));
        }
        return orTerm;
    }

    private static SingleSearchTerm getFolderTerm(int folderID) {
        SingleSearchTerm term = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
        term.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
        term.addOperand(new ConstantOperand<String>(Integer.toString(folderID)));
        return term;
    }

    private static SearchTerm<?> getStartLetterTerm(String pattern) {
        String field = ContactConfig.getInstance().getString(ContactConfig.Property.LETTER_FIELD);
        if (".".equals(pattern) || "#".equals(pattern)) {
            CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
            CompositeSearchTerm orTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
            SingleSearchTerm lessThanTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.LESS_THAN);
            lessThanTerm.addOperand(new ColumnOperand(field));
            lessThanTerm.addOperand(new ConstantOperand<String>("0*"));
            orTerm.addSearchTerm(lessThanTerm);
            SingleSearchTerm greaterThanTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.GREATER_THAN);
            greaterThanTerm.addOperand(new ColumnOperand(field));
            greaterThanTerm.addOperand(new ConstantOperand<String>("z*"));
            orTerm.addSearchTerm(greaterThanTerm);
            andTerm.addSearchTerm(orTerm);
            SingleSearchTerm notEqualsTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.NOT_EQUALS);
            notEqualsTerm.addOperand(new ColumnOperand(field));
            notEqualsTerm.addOperand(new ConstantOperand<String>("z*"));
            andTerm.addSearchTerm(notEqualsTerm);
            return andTerm;
        }
        if (pattern.matches("\\d")) {
            CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
            SingleSearchTerm greaterThanTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.GREATER_THAN);
            greaterThanTerm.addOperand(new ColumnOperand(field));
            greaterThanTerm.addOperand(new ConstantOperand<String>("0*"));
            andTerm.addSearchTerm(greaterThanTerm);
            SingleSearchTerm lessThanTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.LESS_THAN);
            lessThanTerm.addOperand(new ColumnOperand(field));
            lessThanTerm.addOperand(new ConstantOperand<String>("a*"));
            andTerm.addSearchTerm(lessThanTerm);
            return andTerm;
        }
        if (!"all".equals(pattern)) {
            ContactField fallbackField = ContactField.DISPLAY_NAME;
            CompositeSearchTerm orTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
            CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
            CompositeSearchTerm andTerm2 = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
            CompositeSearchTerm notTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.NOT);
            SingleSearchTerm isNullTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.ISNULL);
            isNullTerm.addOperand(new ColumnOperand(field));
            notTerm.addSearchTerm(isNullTerm);
            andTerm.addSearchTerm(notTerm);
            String preparedPattern = SearchAdapter.prepareForSearch(pattern, false, true);
            SingleSearchTerm equalsTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
            equalsTerm.addOperand(new ColumnOperand(field));
            equalsTerm.addOperand(new ConstantOperand<String>(preparedPattern));
            andTerm.addSearchTerm(equalsTerm);
            andTerm2.addSearchTerm(isNullTerm);
            SingleSearchTerm equalsTerm2 = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
            equalsTerm2.addOperand(new ContactFieldOperand(fallbackField));
            equalsTerm2.addOperand(new ConstantOperand<String>(preparedPattern));
            andTerm2.addSearchTerm(equalsTerm2);
            orTerm.addSearchTerm(andTerm);
            orTerm.addSearchTerm(andTerm2);
            return orTerm;
        }
        return null;
    }

    private static SingleSearchTerm getSearchTerm(ContactField field, String pattern, boolean prependWildcard, boolean appendWildcard) throws OXException {
        SingleSearchTerm term = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
        term.addOperand(new ContactFieldOperand(field));
        Search.checkPatternLength(pattern);
        term.addOperand(new ConstantOperand<String>(SearchAdapter.prepareForSearch(pattern, prependWildcard, appendWildcard)));
        return term;
    }

    private static String prepareForSearch(String pattern, boolean prependWildcard, boolean appendWildcard) {
        if (prependWildcard && !pattern.startsWith("*")) {
            pattern = "*" + pattern;
        }
        if (prependWildcard && !pattern.endsWith("*")) {
            pattern = pattern + "*";
        }
        return pattern;
    }

    static {
        ContactField[] emailFields = new ContactField[]{ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3};
        CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
        for (ContactField field : emailFields) {
            SingleSearchTerm term = new SingleSearchTerm(SingleSearchTerm.SingleOperation.ISNULL);
            term.addOperand(new ContactFieldOperand(field));
            andTerm.addSearchTerm(term);
        }
        CompositeSearchTerm notTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.NOT);
        notTerm.addSearchTerm(andTerm);
        SingleSearchTerm distributionListTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.GREATER_THAN);
        distributionListTerm.addOperand(new ContactFieldOperand(ContactField.NUMBER_OF_DISTRIBUTIONLIST));
        distributionListTerm.addOperand(new ConstantOperand<Integer>(0));
        CompositeSearchTerm hasEmailTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
        hasEmailTerm.addSearchTerm(notTerm);
        hasEmailTerm.addSearchTerm(distributionListTerm);
        HAS_EMAIL_TERM = hasEmailTerm;
    }
}

