/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ConsistencyExceptionCodes implements DisplayableOXExceptionCode
{
    COMMUNICATION_PROBLEM("Error communicating with mbean in server: %s", CATEGORY_ERROR, 1),
    REGISTRATION_FAILED("Registration of consistency MBean failed.", CATEGORY_CONFIGURATION, 2),
    UNREGISTRATION_FAILED("Unregistration of consistency MBean failed.", CATEGORY_CONFIGURATION, 3),
    MALFORMED_POLICY("Malformed policy. Policies are formed like \"condition:action\"", CATEGORY_USER_INPUT, 4, "The policy you have entered is malformed. It should look like \"condition:action\"");

    private static final String MALFORMED_POLICY_MSG = "Malformed policy. Policies are formed like \"condition:action\"";
    private static final String COMMUNICATION_PROBLEM_MSG = "Error communicating with mbean in server: %s";
    private static final String REGISTRATION_FAILED_MSG = "Registration of consistency MBean failed.";
    private static final String UNREGISTRATION_FAILED_MSG = "Unregistration of consistency MBean failed.";
    private final String message;
    private final Category category;
    private final int number;
    private String displayMessage;

    private ConsistencyExceptionCodes(String message, Category category, int number) {
        this(message, category, number, null);
    }

    private ConsistencyExceptionCodes(String message, Category category, int number, String displayMessage) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.category = category;
        this.number = number;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return "CSTY";
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

